/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.transition.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.workflow.process.map.AcceptButton;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;

public class CreateAcceptButtonsOnActivityTool
implements Tool {
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.TRANSITION, "create_accept_buttons_on_activity", "Allow to create one or more acceptance buttons on an single activity, which serve as triggers to transition from a source activity to another activity or gateway. The buttonIds can then be used to create conditions on a logic gate. Returns the created buttons' details in the following format: { \"activityId\": \"<id>\", \"createdButtons\": [ { \"acceptButtonId\": \"<id>\", \"acceptButtonName\": \"<name>\" } ] }", "To create accept buttons, write { \"activityId\": \"<id>\", \"acceptButtonNames\": [\"<name1>\", \"<name2>\"] }", CreateAcceptButtonsOnActivityTool.class);
    private final String activityId;
    private final List<String> acceptButtonNames;

    @JsonCreator
    public CreateAcceptButtonsOnActivityTool(@JsonProperty(value="activityId") String activityId, @JsonProperty(value="acceptButtonNames") List<String> acceptButtonNames) {
        this.activityId = activityId;
        this.acceptButtonNames = acceptButtonNames;
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        if (this.activityId == null || this.activityId.isBlank() || this.acceptButtonNames == null || this.acceptButtonNames.isEmpty()) {
            return new ToolResult(false, "Error: Invalid payload. Expecting \"activityId\" and a non-empty \"acceptButtonNames\" array.");
        }
        Process process = toolContext.getProcess();
        Activity activity = process.getActivities().stream().filter(act -> act.getId().equals(this.activityId)).findFirst().orElse(null);
        if (activity == null) {
            return new ToolResult(false, "Error: Activity with activityId: '" + this.activityId + "' doesn't exist!.");
        }
        ArrayList<CreateAcceptButtonResult> createdButtons = new ArrayList<CreateAcceptButtonResult>();
        for (String buttonName : this.acceptButtonNames) {
            String acceptButtonId = this.generateUniqueAcceptButtonId(activity, buttonName);
            AcceptButton newAcceptButton = new AcceptButton(acceptButtonId, buttonName);
            activity.getAcceptButtons().add(newAcceptButton);
            createdButtons.add(new CreateAcceptButtonResult(acceptButtonId, buttonName));
        }
        String formattedData = createdButtons.stream().map(button -> "acceptButtonName: '" + button.acceptButtonName() + "', acceptButtonId: '" + button.acceptButtonId() + "'").reduce("", (acc, item) -> acc.isEmpty() ? item : acc + "\n" + item);
        return new ToolResult(true, "Successfully created " + createdButtons.size() + " accept buttons for activity '" + activity.getName() + "':\n" + formattedData);
    }

    private String generateUniqueAcceptButtonId(Activity activity, String buttonName) {
        String baseAcceptButtonId = Normalizer.normalize(buttonName, Normalizer.Form.NFD).toLowerCase().replaceAll("[\\u0300-\\u036f]", "").replaceAll("\\s+", "_").replaceAll("[^a-z0-9_]", "");
        if (baseAcceptButtonId.length() > 16) {
            baseAcceptButtonId = baseAcceptButtonId.substring(0, 16);
        }
        String baseId = baseAcceptButtonId;
        Object acceptButtonId = baseId;
        int counter = 1;
        while (this.isAcceptButtonIdExists(activity, (String)acceptButtonId)) {
            String counterStr = String.valueOf(counter);
            int maxLength = 16 - counterStr.length();
            String trimmedId = baseId.length() > maxLength ? baseId.substring(0, maxLength) : baseId;
            acceptButtonId = trimmedId + counter;
            ++counter;
        }
        return acceptButtonId;
    }

    private boolean isAcceptButtonIdExists(Activity activity, String acceptButtonId) {
        return activity.getAcceptButtons().stream().anyMatch(b -> b.getId().equals(acceptButtonId));
    }

    public String getActivityId() {
        return this.activityId;
    }

    public List<String> getAcceptButtonNames() {
        return this.acceptButtonNames;
    }

    public record CreateAcceptButtonResult(String acceptButtonId, String acceptButtonName) {
    }
}

