/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.transition;

import com.suncode.pwfl.assistant.AgentContext;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.agent.Agent;
import com.suncode.pwfl.assistant.agent.transition.prompts.TransitionActionPromptProvider;
import com.suncode.pwfl.assistant.agent.transition.prompts.TransitionActionUsePromptProvider;
import com.suncode.pwfl.assistant.agent.transition.prompts.TransitionTaskPromptProvider;
import com.suncode.pwfl.assistant.model.AgentState;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.workflow.process.map.Process;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitionAgent
implements Agent {
    private static final Logger log = LoggerFactory.getLogger(TransitionAgent.class);
    private final AgentState agentState;
    private final TransitionActionPromptProvider actionPromptProvider;
    private final TransitionActionUsePromptProvider actionUsePromptProvider;
    private final TransitionTaskPromptProvider taskPromptProvider;

    public TransitionAgent(AgentContext agentContext, Process process) {
        this.agentState = new AgentState(process);
        List<ToolDefinition> tools = agentContext.getToolRegistry().getToolDefinitionsForAgentType(AgentType.TRANSITION);
        this.actionPromptProvider = new TransitionActionPromptProvider(tools);
        this.actionUsePromptProvider = new TransitionActionUsePromptProvider(tools);
        this.taskPromptProvider = new TransitionTaskPromptProvider(tools);
        log.debug("Created {}", (Object)this);
    }

    @Override
    public AgentType getAgentType() {
        return AgentType.TRANSITION;
    }

    @Override
    public AgentState getState() {
        return this.agentState;
    }

    @Override
    public String getActionPrompt() {
        return this.actionPromptProvider.provide(this.agentState);
    }

    @Override
    public String getActionUsePrompt() {
        return this.actionUsePromptProvider.provide(this.agentState);
    }

    @Override
    public String getTaskPrompt() {
        return this.taskPromptProvider.provide(this.agentState);
    }

    public String toString() {
        return "Transition agent";
    }
}

