/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.main.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.agent.main.prompts.MainAgentAnswerPromptProvider;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalAnswerTool
implements Tool {
    private static final Logger log = LoggerFactory.getLogger(FinalAnswerTool.class);
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.MAIN, "final_answer", "Use this tool to answer the user.", "To answer the user write { \"answer\": \"<answer>\" }", FinalAnswerTool.class);
    private final String answer;

    @JsonCreator
    public FinalAnswerTool(@JsonProperty(value="answer") String answer) {
        this.answer = answer;
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        if (StringUtils.isBlank(this.answer)) {
            return new ToolResult(false, "Error: Invalid payload. Expecting a non-empty \"answer\" string.");
        }
        MainAgentAnswerPromptProvider answerPromptProvider = new MainAgentAnswerPromptProvider();
        String processMapAnalysisRaw = toolContext.getLlmService().chat(answerPromptProvider.provide(toolContext.getState()), toolContext.getUserMessage());
        if (StringUtils.isBlank(processMapAnalysisRaw)) {
            return new ToolResult(false, "Error: Failed to generate response from LLM.");
        }
        return new ToolResult(true, processMapAnalysisRaw);
    }

    public String getAnswer() {
        return this.answer;
    }
}

