/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.main.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentContext;
import com.suncode.pwfl.assistant.AgentExecutor;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.agent.variable.VariableAgent;
import com.suncode.pwfl.assistant.model.ActionResult;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivitiesVariablesAgentTool
implements Tool {
    private static final Logger log = LoggerFactory.getLogger(ActivitiesVariablesAgentTool.class);
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.MAIN, "activities_variables_agent", "This tool is a specialized LLM agent for managing the core components of a business process map. It is responsible for creating, modifying, deleting, and retrieving information about the process itself, its steps (activities), and its data fields (variables). You MUST delegate any user request related to these components to this agent. The agent's capabilities include:\n- **Process Management**: Setting and retrieving the process name.\n- **Activity Management**: Creating, updating, deleting, and searching for activities. Activities represent individual steps or tasks within the process.\n- **Variable Management**: Creating, updating, deleting, and searching for variables. Variables represent data fields on forms within activities (e.g., invoice number, amount, date). Variables do not represent acceptance buttons or buttons!.\n- **Assigning Variables to Activities**: Assigning variables to specific activities and defining their visibility (e.g., editable, read-only, hidden). This determines what data is available and how it can be interacted with at each process stage.\n\nYou MUST provide a single, complete instruction that represents a full logical task related to the process components if you want to delegate the task to this agent. Avoid splitting the task into multiple smaller tasks (if possible) - if the agent receives a complete instruction, it will be able to handle it properly and plan what to do with it by itself. After the work is done, the agent will inform you about the results of your query.", "To invoke the agent, write { \"query\": \"<your query>\" }. Your query should be a clear and complete instruction that represents a full logical task related to the process components. Avoid splitting the task into multiple smaller queries. The agent can handle creating the necessary elements and assigning them in a single operation. For example: \"Create a new activity named 'Invoice Approval' and add two variables to it: 'Invoice Amount' of type FLOAT and 'Approval Justification' of type STRING. Set 'Invoice Amount' as read-only and 'Approval Justification' as editable.\" Provide all necessary details in the query, such as:\n- Names for new activities or variables.\n- Names for new variables (e.g., 'STRING', 'INTEGER', 'DATE').\n- For assignments variables to activities, specify the names of activites and variables (also visibility type if provided by user)", ActivitiesVariablesAgentTool.class);
    private final String query;

    @JsonCreator
    public ActivitiesVariablesAgentTool(@JsonProperty(value="query") String query) {
        this.query = query;
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        if (this.query == null || this.query.isBlank()) {
            return new ToolResult(false, "Error: Invalid payload. Expecting a non-empty \"query\" string.");
        }
        try {
            AgentContext context = toolContext.getContext();
            VariableAgent variableAgent = new VariableAgent(context, toolContext.getProcess());
            AgentExecutor agentExecutor = new AgentExecutor(context);
            agentExecutor.execute(variableAgent, this.query);
            ActionResult finalAnswer = variableAgent.getState().getFinalAnswer();
            String response = finalAnswer != null ? finalAnswer.getData().toString() : "Could not return final answer";
            return new ToolResult(true, response);
        }
        catch (Exception e) {
            log.error("Failed to execute activities/variables agent", (Throwable)e);
            return new ToolResult(false, "Error executing agent: " + e.getMessage());
        }
    }

    public String getQuery() {
        return this.query;
    }
}

