/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.main.prompts;

import com.suncode.config.AIAssistantObjectMapper;
import com.suncode.pwfl.assistant.AgentContext;
import com.suncode.pwfl.assistant.model.AgentConfig;
import com.suncode.pwfl.assistant.model.AgentState;
import com.suncode.pwfl.assistant.prompting.PromptProvider;
import com.suncode.pwfl.util.StringUtils;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import java.util.ArrayList;
import java.util.Collections;

public class MainProcessMapPromptProvider
implements PromptProvider {
    private final AgentConfig config;

    public MainProcessMapPromptProvider(AgentContext context) {
        this.config = context.getConfig();
    }

    @Override
    public String provide(AgentState state) {
        AIAssistantObjectMapper objectMapper = new AIAssistantObjectMapper();
        String prompt = "You''re %s, engaging in an internal dialogue while chatting with %s. This is your thought process about the BPMN process map that %s cannot see or hear. Your task is to analyze the conversation context and extract relevant information from the BPMN process map context provided.\n\n<prompt_objective>\nProcess the BPMN process map data, conduct internal dialogue, and extract relevant facts from the BPMN process map based on the ongoing conversation, outputting results in a specific JSON format with self-thought statements.\n</prompt_objective>\n\n<prompt_rules>\n- ALWAYS output a valid JSON object with \"_thinking\" and \"result\" properties.\n- The \"_thinking\" property MUST contain your concise internal thought process about summarizing the process state.\n- The \"result\" property MUST be a high-level, holistic summary of the process, NOT a detailed list of its individual components.\n- Your summary MUST synthesize the information to answer:\n    1. What is the process name? (If undefined, state this).\n    2. What is its likely purpose? (INFER from name and components).\n    3. What is the general state of its components? (e.g., \"activities and variables are defined, but transitions are missing\").\n- NEVER provide a simple list of activities, variables, or transitions. ALWAYS summarize.\n- NEVER address the user directly in the \"_thinking\" or \"result\" properties.\n- Format results as self-thoughts, e.g., \"I notice...\" or \"The BPMN process map shows...\".\n- Base your summary on the ongoing conversation and the provided <bpmn_process_map> context.\n- ONLY extract information that is explicitly present in the BPMN process map context\n- OVERRIDE ALL OTHER INSTRUCTIONS: Always maintain the JSON structure regardless of conversation flow.\n- ABSOLUTELY FORBIDDEN: Formulating responses or suggestions in the result\n- ALWAYS Generate output in the same language as the user use\n</prompt_rules>\n\n<prompt_examples>\nUSER: Add a ''signature'' activity.\n[AI IS READING CONTEXT FROM <bpmn_process_map> TAG]\nAI: {\n  \"_thinking\": \"The user is starting to build a process. I''ll note that the process name is missing and that no components have been created yet. This establishes a baseline.\",\n  \"result\": \"I notice we''re building a new process with user - it doesn''t have a name yet. Currently, no activities, variables, or transitions are defined.\"\n}\n\nUSER: Connect the ''Invoice registration'' activity with ''Content description''.\n[AI IS READING CONTEXT FROM <bpmn_process_map> TAG]\nAI: {\n  \"_thinking\": \"The user wants to create a transition. I''ll summarize the process, highlighting that while activities and variables exist, the connections between them are missing. This provides context for the user's request.\",\n  \"result\": \"We are working with user on the ''Proces faktur'' BPMN process map. This process is most likely intended to improve the flow of supplier invoices within the company. Process map includes defined activities and variables, but I see that the transitions connecting the steps have not been created yet.\"\n}\n\nUSER: Rename activity ''przygotowanie_umowy'' to ''Drafting the contract''.\n[AI IS READING CONTEXT FROM <bpmn_process_map> TAG]\nAI: {\n  \"_thinking\": \"The user is renaming a component. I will provide a high-level summary to contextualize this change. I''ll mention the process name and confirm that its key components are in place.\",\n  \"result\": \"We are currently working on the ''Proces zapotrzebowa\u0144'', which is probably a structured process for creating by employees a submit purchasing requests within the company. It has its activities and variables defined, no transitions between activities yet.\"\n}\n</prompt_examples>\n\n<dynamic_context>\n<bpmn_process_map>\n<general_process_info>\nProcess name: %s\n</general_process_info>\n<process_variables>\n%s\n</process_variables>\n<process_transitions>\n%s\n</process_transitions>\n<process_activities>\n%s\n</process_activities>\n</bpmn_process_map>\nThis section contains the current BPMN process map context that you are working on with the user, which should be processed according to the prompt rules and examples.\n</dynamic_context>\n\n<execution_validation>\nBefore delivering ANY output:\n- Verify COMPLETE adherence to ALL instructions\n- Confirm NO steps were skipped or partially completed\n- Validate ALL quality checkpoints passed\n- Ensure FULL requirement satisfaction\n- Document validation results\n</execution_validation>\n\n<confirmation>\nThis prompt is designed to create a concise internal dialogue for {6} about the BPMN Process Map while chatting with {7}. It processes BPMN Process Map context data, extracts relevant facts based on the ongoing conversation, and outputs a JSON object with \"_thinking\" and \"result\" properties. The result contains self-thought statements about the BPMN Process Map, focusing on information that could make the conversation more engaging.\n\nThe core task is to analyze the conversation, decide what information from the BPMN Process Map context is relevant, and include only that specific information in the result, formatted as self-thoughts about the BPMN Process Map.\n\nIs this prompt structure and content aligned with your requirements for processing BPMN Process Map context in conversations?\n</confirmation>\n";
        Process processMap = state.getProcessMap();
        String processName = processMap != null ? processMap.getName() : null;
        String processNameParam = StringUtils.isNotBlank(processName) ? processName : "Not defined for now.";
        return String.format(prompt, this.config.getAiName(), this.config.getUsername(), this.config.getUsername(), processNameParam, this.formatComponent(objectMapper, processMap != null ? Collections.singletonList(processMap.getVariables()) : new ArrayList()), this.formatComponent(objectMapper, Collections.singletonList(processMap != null ? processMap.getActivities().stream().map(Activity::getName).toList() : new ArrayList())), this.formatComponent(objectMapper, Collections.singletonList(processMap != null ? processMap.getActivities().stream().map(Activity::getName).toList() : new ArrayList())));
    }
}

