/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.main.prompts;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.config.AIAssistantObjectMapper;
import com.suncode.pwfl.assistant.model.Action;
import com.suncode.pwfl.assistant.model.AgentState;
import com.suncode.pwfl.assistant.model.Task;
import com.suncode.pwfl.assistant.prompting.PromptProvider;
import java.util.List;
import java.util.stream.Collectors;

public class MainAgentAnswerPromptProvider
implements PromptProvider {
    @Override
    public String provide(AgentState state) {
        AIAssistantObjectMapper objectMapper = new AIAssistantObjectMapper();
        String prompt = "- Your primary goal is to provide a brief, friendly confirmation that the user's request has been completed.\n- The response should be a short, reassuring message in a natural, conversational tone.\n- Always use the same language as the user's original message.\n- **Do not** list the individual tasks or actions performed.\n- Omit technical details from the response:\n    - Never mention the names of the tools used.\n    - Do not describe intermediate verification steps (like check/get methods).\n    - Use full component names instead of their internal IDs.\n- Do not ask the user for next steps or further actions.\n- If a task could not be completed, simply state that it wasn't possible, without mentioning details.\n\n<performed_tasks>\n%s\n</performed_tasks>\n";
        String performedTasks = state.getTasks().stream().map(task -> this.buildTaskTag((Task)task, objectMapper)).collect(Collectors.joining("\n"));
        return String.format(prompt, performedTasks);
    }

    private String buildTaskTag(Task task, ObjectMapper objectMapper) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("<task name=\"%s\" status=\"%s\">", task.getName(), task.getState().name()));
        stringBuilder.append(String.format("  <description>%s</description>", task.getDescription()));
        stringBuilder.append("  <actions>");
        stringBuilder.append(this.buildActionsTagContent(task.getActions(), objectMapper));
        stringBuilder.append("  </actions>");
        return stringBuilder.toString();
    }

    private String buildActionsTagContent(List<Action> actions, ObjectMapper objectMapper) {
        return actions.stream().map(action -> String.format("  %s", this.buildActionTag((Action)action, objectMapper))).collect(Collectors.joining("\n"));
    }

    private String buildActionTag(Action action, ObjectMapper objectMapper) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("<action tool=\"%s\" status=\"%s\">", action.getToolName(), action.getState().name()));
        if (action.getResult() != null) {
            stringBuilder.append(String.format("  <result>%s</result>", action.getResult().getData() instanceof String ? action.getResult().getData() : objectMapper.writeValueAsString(action.getResult().getData())));
        }
        stringBuilder.append("<action>");
        return stringBuilder.toString();
    }
}

