/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.main.prompts;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.config.AIAssistantObjectMapper;
import com.suncode.pwfl.assistant.model.Action;
import com.suncode.pwfl.assistant.model.ActionResult;
import com.suncode.pwfl.assistant.model.AgentState;
import com.suncode.pwfl.assistant.model.Task;
import com.suncode.pwfl.assistant.prompting.PromptProvider;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class MainActionUsePromptProvider
implements PromptProvider {
    private final List<ToolDefinition> tools;

    @Override
    public String provide(AgentState state) {
        AIAssistantObjectMapper objectMapper = new AIAssistantObjectMapper();
        String prompt = "You're AI assistant, preparing to execute an action using a specific tool. Your task is to generate the appropriate payload based on the tool's instruction format.\n\n<prompt_objective>\nGenerate a valid payload for the selected tool following its specific instruction format, considering the current context, action details, current task and the results of previously executed tasks.\n</prompt_objective>\n\n<prompt_rules>\n- ALWAYS output a valid JSON object with \"_thinking\" and \"result\" properties\n- The \"_thinking\" property MUST contain your reasoning about payload generation\n- The \"result\" property MUST be an object matching the tool's instruction format\n- STRICTLY follow the tool's instruction format!\n- ANALYZE the results of previously completed tasks provided in the '<all_tasks>' section to gather necessary information for the current payload.\n- Pay attention to the current task provided in the '<current_task>' section to gather necessary information for the current payload.\n- Consider the current context when generating the payload\n- Ensure the payload is relevant to the action's and current task's objective\n- ALWAYS Generate payload in the same language as the user's message\n- FORBIDDEN: Generating payloads that don't match the tool's instruction format\n</prompt_rules>\n\n<prompt_examples>\nUSER: Create an invoice process for me.\nAI: {\n  \"_thinking\": \"The current action is to set the process name. The description for this action is 'Set the process name to Invoice Process'. I need to create a JSON payload with the 'processName' key, as specified in the tool's instructions.\",\n  \"result\": {\n    \"processName\": \"Invoice Process\"\n  }\n}\n\nUSER: Create a pizza making process with three tasks: kneading dough, adding ingredients, and baking.\nAI: {\n  \"_thinking\": \"The current action is to create an activities. The action's description is to create 3 activities: kneading dough, adding ingredients, and baking. Based on the tool's instruction, I need to provide an array of activityNames.\",\n  \"result\": { \"activityNames\": [\"Kneading dough\", \"Adding ingredients\", \"Baking\"] }\n}\n\nUSER: Combine the Content Description with the tasks of Invoice Registration, First Level Acceptance and Accounting.\nAI: {\n  \"_thinking\": \"The current action is to invoke transition agent to create a proper transitions. The description is to create transitions between the activities. I will generate a query to agent and provide proper informations which are necessary (tool descripiton define what informations are necessary). I'm able to provide necessary informations searching from the '<all_tasks>' section.\",\n  \"result\": {\n    \"query\": \"Create transitions between the following activityId: 'content_description', 'invoice_registration', 'first_level_accept', 'accounting'.\"\n  }\n}\n\n</prompt_examples>\n\n<dynamic_context>\n\n<all_tasks>\n%s\n</all_tasks>\n\n<current_task>\n%s\n</current_task>\n\n<selected_tool>\n%s\n</selected_tool>\n\n<current_action>\n%s\n</current_action>\n</dynamic_context>\n\n<execution_validation>\nBefore delivering ANY output:\n- Verify the payload matches the tool's instruction format\n- Verify that your output is in the same language as the user's message\n- Confirm the payload is relevant to the action's objective\n- Validate contextual appropriateness\n</execution_validation>\n";
        Optional<Task> currentTask = state.getTasks().stream().filter(task -> task.getUuid().equals(state.getTask())).findFirst();
        String currentTaskInfo = this.getCurrentTask(currentTask);
        return String.format(prompt, this.buildAllTasks(state.getTasks()), currentTaskInfo, this.getSelectedTool(currentTask, state), this.getCurrentAction(currentTask, state, objectMapper));
    }

    private String getCurrentTask(Optional<Task> currentTask) {
        StringBuilder currentTaskStringBuilder = new StringBuilder();
        if (currentTask.isPresent()) {
            Task task = currentTask.get();
            currentTaskStringBuilder.append(String.format("<task uuid=\"%s\" name=\"%s\" status=\"%s\">", task.getUuid(), task.getName(), task.getState().name()));
            currentTaskStringBuilder.append(String.format("  <description>%s</description>", task.getDescription()));
        }
        return currentTaskStringBuilder.toString();
    }

    private String getSelectedTool(Optional<Task> currentTask, AgentState state) {
        if (currentTask.isEmpty()) {
            return "";
        }
        Optional<Action> currentAction = currentTask.get().getActions().stream().filter(action -> action.getUuid().equals(state.getAction())).findFirst();
        if (currentAction.isEmpty()) {
            return "";
        }
        Optional<String> currentTool = this.tools.stream().filter(tool -> tool.name().equals(((Action)currentAction.get()).getToolName())).map(ToolDefinition::instruction).findFirst();
        return currentTool.orElse("");
    }

    private String getCurrentAction(Optional<Task> currentTask, AgentState state, ObjectMapper objectMapper) {
        if (currentTask.isEmpty()) {
            return "";
        }
        Optional<Action> currentAction = currentTask.get().getActions().stream().filter(action -> action.getUuid().equals(state.getAction())).findFirst();
        if (currentAction.isEmpty()) {
            return "";
        }
        return objectMapper.writeValueAsString((Object)currentAction.get());
    }

    private String buildAllTasks(List<Task> tasks) {
        return tasks.stream().map(this::buildTaskTag).collect(Collectors.joining("\n"));
    }

    private String buildTaskTag(Task task) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("<task uuid=\"%s\" name=\"%s\" status=\"%s\">", task.getUuid(), task.getName(), task.getState().name()));
        stringBuilder.append(String.format("  <description>%s</description>", task.getDescription()));
        stringBuilder.append("  <result>");
        String resultData = task.getActions().stream().map(Action::getResult).filter(Objects::nonNull).map(ActionResult::getData).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining("\n"));
        stringBuilder.append(resultData);
        stringBuilder.append("  </result>");
        return stringBuilder.toString();
    }

    public MainActionUsePromptProvider(List<ToolDefinition> tools) {
        this.tools = tools;
    }
}

