/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.main;

import com.suncode.pwfl.assistant.AgentContext;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.agent.Agent;
import com.suncode.pwfl.assistant.agent.main.prompts.MainActionPromptProvider;
import com.suncode.pwfl.assistant.agent.main.prompts.MainActionUsePromptProvider;
import com.suncode.pwfl.assistant.agent.main.prompts.MainProcessMapPromptProvider;
import com.suncode.pwfl.assistant.agent.main.prompts.MainTaskPromptProvider;
import com.suncode.pwfl.assistant.model.AgentState;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainAgent
implements Agent {
    private static final Logger log = LoggerFactory.getLogger(MainAgent.class);
    private final AgentState state = new AgentState();
    private final MainProcessMapPromptProvider processMapPromptProvider;
    private final MainActionPromptProvider actionPromptProvider;
    private final MainActionUsePromptProvider actionUsePromptProvider;
    private final MainTaskPromptProvider taskPromptProvider;

    public MainAgent(AgentContext context) {
        List<ToolDefinition> tools = context.getToolRegistry().getToolDefinitionsForAgentType(AgentType.MAIN);
        this.processMapPromptProvider = new MainProcessMapPromptProvider(context);
        this.actionPromptProvider = new MainActionPromptProvider(tools);
        this.actionUsePromptProvider = new MainActionUsePromptProvider(tools);
        this.taskPromptProvider = new MainTaskPromptProvider(tools);
        log.debug("Created {}", (Object)this);
    }

    @Override
    public AgentType getAgentType() {
        return AgentType.MAIN;
    }

    @Override
    public AgentState getState() {
        return this.state;
    }

    @Override
    public Optional<String> getThinkingPrompt() {
        return Optional.of(this.processMapPromptProvider.provide(this.state));
    }

    @Override
    public String getActionPrompt() {
        return this.actionPromptProvider.provide(this.state);
    }

    @Override
    public String getActionUsePrompt() {
        return this.actionUsePromptProvider.provide(this.state);
    }

    @Override
    public String getTaskPrompt() {
        return this.taskPromptProvider.provide(this.state);
    }

    public String toString() {
        return "Main agent";
    }
}

