/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant;

import com.suncode.pwfl.assistant.AgentContext;
import com.suncode.pwfl.assistant.agent.Agent;
import com.suncode.pwfl.assistant.model.Action;
import com.suncode.pwfl.assistant.model.AgentActionState;
import com.suncode.pwfl.assistant.model.AgentConfig;
import com.suncode.pwfl.assistant.model.AgentState;
import com.suncode.pwfl.assistant.model.AgentTaskState;
import com.suncode.pwfl.assistant.model.Task;
import com.suncode.pwfl.assistant.phase.AgentActionPlanningPhase;
import com.suncode.pwfl.assistant.phase.AgentActionUsagePhase;
import com.suncode.pwfl.assistant.phase.AgentTaskPlanningPhase;
import com.suncode.pwfl.assistant.phase.AgentThinkingPhase;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentExecutor {
    private static final Logger log = LoggerFactory.getLogger(AgentExecutor.class);
    private final AgentConfig config;
    private final AgentThinkingPhase thinkingPhase;
    private final AgentTaskPlanningPhase taskPlanningPhase;
    private final AgentActionPlanningPhase actionPlanningPhase;
    private final AgentActionUsagePhase actionPhase;

    public AgentExecutor(AgentContext context) {
        this.config = context.getConfig();
        this.thinkingPhase = new AgentThinkingPhase(context);
        this.taskPlanningPhase = new AgentTaskPlanningPhase(context);
        this.actionPlanningPhase = new AgentActionPlanningPhase(context);
        this.actionPhase = new AgentActionUsagePhase(context);
    }

    public void execute(Agent agent, String userMessage) {
        log.debug("[{}] Executing agent", (Object)agent);
        if (agent.getThinkingPrompt().isPresent()) {
            log.debug("[{}] Executing thinking phase", (Object)agent);
            this.thinkingPhase.execute(agent, agent.getThinkingPrompt().get(), userMessage);
        }
        AgentState state = agent.getState();
        for (int step = 0; step < this.config.getMaxSteps(); ++step) {
            state.setStep(0);
            log.info("[{}][{}] Executing task planning phase", (Object)agent, (Object)step);
            this.taskPlanningPhase.execute(agent, userMessage);
            log.debug("[{}][{}] Executing action planning phase", (Object)agent, (Object)step);
            this.actionPlanningPhase.execute(agent, userMessage);
            log.info("[{}][{}] Executing action usage phase", (Object)agent, (Object)step);
            this.actionPhase.execute(agent, userMessage);
            Optional<Task> currentTaskOptional = state.getTasks().stream().filter(task -> task.getUuid().equals(state.getTask())).findFirst();
            if (currentTaskOptional.isEmpty()) {
                log.warn("[{}][{}] No task found", (Object)agent, (Object)step);
                break;
            }
            Task currentTask = currentTaskOptional.get();
            Optional<Action> currentActionOptional = currentTask.getActions().stream().filter(action -> action.getUuid().equals(state.getAction())).findFirst();
            if (currentActionOptional.isEmpty()) {
                log.warn("[{}][{}] No action found", (Object)agent, (Object)step);
                break;
            }
            Action currentAction = currentActionOptional.get();
            if (currentAction.getToolName().equals("answer_to_agent") || currentAction.getToolName().equals("final_answer")) {
                log.info("[{}][{}] Setting final answer", (Object)agent, (Object)step);
                state.setFinalAnswer(currentActionOptional.get().getResult());
                break;
            }
            if (currentAction.getState() == AgentActionState.COMPLETED) {
                log.info("[{}][{}] Setting task completed", (Object)agent, (Object)step);
                currentTask.setState(AgentTaskState.COMPLETED);
                continue;
            }
            if (currentAction.getState() != AgentActionState.FAILED) continue;
            currentTask.incrementFailureCount();
            log.info("[{}][{}] Increasing failure count to {}", new Object[]{agent, step, currentTask.getFailureCount()});
            if (currentTask.getFailureCount() > 2) {
                log.info("[{}][{}] Setting task skipped", (Object)agent, (Object)step);
                currentTask.setState(AgentTaskState.SKIPPED);
                continue;
            }
            log.info("[{}][{}] Setting task failed", (Object)agent, (Object)step);
            currentTask.setState(AgentTaskState.FAILED);
        }
    }
}

