package com.suncode.pwfl.xpdl.builder;

class XpdlWorkflowPointBuilder
{
    private String participantId;

    private String activityId;

    private int xOffset;

    private int yOffset;

    private XpdlTransitionStyle transitionStyle = XpdlTransitionStyle.NO_ROUTING_ORTHOGONAL;

    private XpdlWorkflowPointBuilder( String participantId, String activityId, int xOffset, int yOffset )
    {
        this.participantId = participantId;
        this.activityId = activityId;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public static XpdlWorkflowPointBuilder create( String participantId, String activityId, int xOffset, int yOffset  )
    {
        return new XpdlWorkflowPointBuilder( participantId, activityId, xOffset, yOffset );
    }

    public XpdlWorkflowPointBuilder withTransitionStyle( XpdlTransitionStyle transitionStyle )
    {
        this.transitionStyle = transitionStyle;
        return this;
    }

    @Override
    public String toString()
    {
        return "JaWE_GRAPH_PARTICIPANT_ID=" + participantId
            + ",CONNECTING_ACTIVITY_ID=" + activityId
            + ",X_OFFSET=" + xOffset
            + ",Y_OFFSET=" + yOffset
            + ",JaWE_GRAPH_TRANSITION_STYLE=" + transitionStyle
            + ",TYPE=END_DEFAULT";
    }
} 