package com.suncode.pwfl.xpdl.builder;

import com.suncode.pwfl.workflow.process.map.JoinType;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

@Getter
class XpdlTransitionRestrictions
{

    private JoinType joinType;

    private XpdlSplitType splitType;

    private List<String> transitionRefs = new ArrayList<>();

    private XpdlTransitionRestrictions()
    {

    }

    public static XpdlTransitionRestrictions create()
    {
        return new XpdlTransitionRestrictions();
    }

    public XpdlTransitionRestrictions withJoinType( JoinType joinType )
    {
        this.joinType = joinType;
        return this;
    }

    public XpdlTransitionRestrictions withSplitType( XpdlSplitType splitType )
    {
        this.splitType = splitType;
        return this;
    }

    public XpdlTransitionRestrictions withTransitionRefs( List<String> transitionRefs )
    {
        this.transitionRefs = transitionRefs;
        return this;
    }

}