package com.suncode.pwfl.xpdl.builder;

import lombok.AccessLevel;
import lombok.RequiredArgsConstructor;

/**
 * <p>Klasa bazowana na komendach SVG z dokumentacji Raphael:
 * <a href="https://dmitrybaranovskiy.github.io/raphael/reference.html#Paper.path">Paper.path</a>
 * </p>
 * <p>Duża litera komendy oznacza absolutne wartości, mała litera relatywne wartości.</p>
 * <p>Pełna lista komend:
 * <ul>
 * <li>M - moveto - (x y)+</li>
 * <li>Z - closepath - (none)</li>
 * <li>L - lineto - (x y)+</li>
 * <li>H - horizontal lineto - x+</li>
 * <li>V - vertical lineto - y+</li>
 * <li>C - curveto - (x1 y1 x2 y2 x y)+</li>
 * <li>S - smooth curveto - (x2 y2 x y)+</li>
 * <li>Q - quadratic Bézier curveto - (x1 y1 x y)+</li>
 * <li>T - smooth quadratic Bézier curveto - (x y)+</li>
 * <li>A - elliptical arc - (rx ry x-axis-rotation large-arc-flag sweep-flag x y)+</li>
 * <li>R - Catmull-Rom curveto* - x1 y1 (x y)+</li>
 * </ul>
 * </p>
 */
@RequiredArgsConstructor( access = AccessLevel.PRIVATE )
class XpdlLinePathBuilder
{

    private final StringBuilder pathBuilder = new StringBuilder();

    public static XpdlLinePathBuilder create()
    {
        return new XpdlLinePathBuilder();
    }

    public XpdlLinePathBuilder moveTo( int x, int y )
    {
        pathBuilder.append( "M" )
            .append( x ).append( ' ' ).append( y );
        return this;
    }

    public XpdlLinePathBuilder lineTo( int x, int y )
    {
        pathBuilder.append( "L" )
            .append( x ).append( ' ' ).append( y );
        return this;
    }

    public XpdlLinePathBuilder rightArrow( int x, int y )
    {
        return moveTo( x, y )
            .lineTo( x - 8, y - 4 )
            .lineTo( x - 8, y + 4 )
            .lineTo( x, y )
            .closePath();
    }

    public XpdlLinePathBuilder closePath()
    {
        pathBuilder.append( "Z" );
        return this;
    }

    public String build()
    {
        return pathBuilder.toString();
    }

}
