package com.suncode.pwfl.xpdl.builder;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

abstract class XpdlBaseBuilder
{

    protected static final String XML_VERSION = "1.0";

    protected static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern( "yyyy-MM-dd HH:mm:ss" );

    // Common namespaces
    protected static final String XPDL_NAMESPACE = "http://www.wfmc.org/2002/XPDL1.0";

    protected static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";

    // Common element names with namespace
    protected static final String ELEMENT_PACKAGE = "xpdl:Package";

    protected static final String ELEMENT_PACKAGE_HEADER = "xpdl:PackageHeader";

    protected static final String ELEMENT_WORKFLOW_PROCESS = "xpdl:WorkflowProcess";

    protected static final String ELEMENT_PROCESS_HEADER = "xpdl:ProcessHeader";

    protected static final String ELEMENT_DATA_FIELDS = "xpdl:DataFields";

    protected static final String ELEMENT_DATA_FIELD = "xpdl:DataField";

    protected static final String ELEMENT_PARTICIPANTS = "xpdl:Participants";

    protected static final String ELEMENT_PARTICIPANT = "xpdl:Participant";

    protected static final String ELEMENT_PARTICIPANT_TYPE = "xpdl:ParticipantType";

    protected static final String ELEMENT_ACTIVITIES = "xpdl:Activities";

    protected static final String ELEMENT_ACTIVITY = "xpdl:Activity";

    protected static final String ELEMENT_IMPLEMENTATION = "xpdl:Implementation";

    protected static final String ELEMENT_NO = "xpdl:No";

    protected static final String ELEMENT_PERFORMER = "xpdl:Performer";

    protected static final String ELEMENT_TRANSITIONS = "xpdl:Transitions";

    protected static final String ELEMENT_FORMAL_PARAMETERS = "xpdl:FormalParameters";

    protected static final String ELEMENT_FORMAL_PARAMETER = "xpdl:FormalParameter";

    protected static final String ELEMENT_DATA_TYPE = "xpdl:DataType";

    protected static final String ELEMENT_BASIC_TYPE = "xpdl:BasicType";

    protected static final String ELEMENT_DESCRIPTION = "xpdl:Description";

    protected static final String ELEMENT_EXTENDED_ATTRIBUTES = "xpdl:ExtendedAttributes";

    protected static final String ELEMENT_EXTENDED_ATTRIBUTE = "xpdl:ExtendedAttribute";

    protected static final String ELEMENT_CREATED = "xpdl:Created";

    protected static final String ELEMENT_TRANSITION = "xpdl:Transition";

    protected static final String ELEMENT_XPDL_VERSION = "xpdl:XPDLVersion";

    protected static final String ELEMENT_VENDOR = "xpdl:Vendor";

    protected static final String ELEMENT_AUTHOR = "xpdl:Author";

    protected static final String ELEMENT_SCRIPT = "xpdl:Script";

    protected static final String ELEMENT_WORKFLOW_PROCESSES = "xpdl:WorkflowProcesses";

    // Common attribute names
    protected static final String ATTR_ID = "Id";

    protected static final String ATTR_NAME = "Name";

    protected static final String ATTR_MODE = "Mode";

    protected static final String ATTR_TYPE = "Type";

    protected static final String ATTR_VALUE = "Value";

    protected static final String ATTR_FROM = "From";

    protected static final String ATTR_TO = "To";

    protected static final String ATTR_IS_ARRAY = "IsArray";

    // Common string constants
    protected static final String STRING_MODE_IN = "IN";

    protected static final String STRING_MODE_INOUT = "INOUT";

    protected static final String STRING_TYPE_STRING = "STRING";

    protected static final String STRING_TYPE_INTEGER = "INTEGER";

    protected static final String STRING_TYPE_FLOAT = "FLOAT";

    protected static final String STRING_TYPE_BOOLEAN = "BOOLEAN";

    protected static final String STRING_TYPE_DATETIME = "DATETIME";

    protected static final String STRING_FALSE = "FALSE";

    protected static final String STRING_TRUE = "TRUE";

    protected static final String STRING_TYPE_ROLE = "ROLE";

    // Extended attribute names
    protected static final String EXT_ATTR_JAWE_GRAPH_TRANSITION_STYLE = "JaWE_GRAPH_TRANSITION_STYLE";

    protected static final String EXT_ATTR_FIRST_LINE_DIRECTION = "FIRST_LINE_DIRECTION";

    protected static final String EXT_ATTR_LINE_PATH_DEF = "LINE_PATH_DEF";

    protected static final String EXT_ATTR_JAWE_GRAPH_WORKFLOW_PARTICIPANT_ORDER = "JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDER";

    protected static final String EXT_ATTR_JAWE_GRAPH_START_OF_WORKFLOW = "JaWE_GRAPH_START_OF_WORKFLOW";

    protected static final String EXT_ATTR_JAWE_GRAPH_END_OF_WORKFLOW = "JaWE_GRAPH_END_OF_WORKFLOW";

    protected static final String EXT_ATTR_PROCESS_NAME_MASK = "PROCESS_NAME_MASK";

    protected static final String EXT_ATTR_TABLES = "TABLES";

    protected static final String EXT_ATTR_ATTACHMENT_DIRECTORY = "ATTACHMENT_DIRECTORY";

    protected static final String EXT_ATTR_JAWE_CONFIGURATION = "JaWE_CONFIGURATION";

    protected static final String EXT_ATTR_EDITING_TOOL = "EDITING_TOOL";

    protected static final String EXT_ATTR_EDITING_TOOL_VERSION = "EDITING_TOOL_VERSION";

    protected static final String EXT_ATTR_EVENT_ACTION_ID_COUNTER = "EVENT_ACTION_ID_COUNTER";

    protected static final String EXT_ATTR_PWE_VERSION = "PWE_VERSION";

    protected static final String EXT_ATTR_SUBTYPE = "SUBTYPE";

    protected static final String EXT_ATTR_ARRAY = "ARRAY";

    protected static final String EXT_ATTR_FORMAT = "FORMAT";

    protected static final String EXT_ATTR_DECIMAL_PRECISION = "DECIMAL_PRECISION";

    protected static final String EXT_ATTR_THOUSAND_SEPARATOR = "THOUSAND_SEPARATOR";

    protected static final String EXT_ATTR_CREATION_DATE = "CREATION_DATE";

    protected static final String EXT_ATTR_MODIFICATION_DATE = "MODIFICATION_DATE";

    protected static final String EXT_ATTR_WIDTH = "WIDTH";

    protected static final String EXT_ATTR_HEIGHT = "HEIGHT";

    protected static final String EXT_ATTR_JAWE_GRAPH_PARTICIPANT_ID = "JaWE_GRAPH_PARTICIPANT_ID";

    protected static final String EXT_ATTR_JAWE_GRAPH_OFFSET = "JaWE_GRAPH_OFFSET";

    protected static final String EXT_ATTR_VARIABLE_TO_PROCESS_UPDATE = "VariableToProcess_UPDATE";

    protected static final String EXT_ATTR_VARIABLE_TO_PROCESS_VIEW = "VariableToProcess_VIEW";

    protected static final String EXT_ATTR_VARIABLE_TO_PROCESS_HIDDEN = "VariableToProcess_HIDDEN";

    protected static final String EXT_ATTR_ACTION_ACCEPT_BUTTON = "ACTION_ACCEPT_BUTTON";

    protected static final String EXT_ATTR_EVENTS = "EVENTS";

    protected Element createElement( Document document, String name )
    {
        return document.createElement( name );
    }

    protected Element createElementNS( Document document, String namespace, String name )
    {
        return document.createElementNS( namespace, name );
    }

    protected String formatDateTime( LocalDateTime dateTime )
    {
        return dateTime.format( DATE_TIME_FORMATTER );
    }

    public abstract Element buildElement( Document document );

    protected void addAttribute( Element element, String name, String value )
    {
        element.setAttribute( name, value );
    }

    protected void addExtendedAttribute( Document document, Element parent, String name, String value )
    {
        Element extAttr = document.createElementNS( XPDL_NAMESPACE, ELEMENT_EXTENDED_ATTRIBUTE );
        extAttr.setAttribute( ATTR_NAME, name );
        extAttr.setAttribute( ATTR_VALUE, value );
        parent.appendChild( extAttr );
    }
} 