package com.suncode.pwfl.workflow.process.map.zipped;

import com.google.common.collect.Streams;
import com.suncode.pwfl.workflow.process.map.Package;
import com.suncode.pwfl.workflow.process.map.element.PackageElement;
import lombok.Getter;

import java.util.List;

@Getter
public class ZippedPackage
    extends Zipped<Package, PackageElement>
{

    private final List<ZippedProcess> zippedProcesses;

    public ZippedPackage( Package model, PackageElement element )
    {
        super( model, element );

        zippedProcesses = Streams.zip(
            model.getProcesses().stream(),
            element.getProcesses().stream(),
            ZippedProcess::new
        ).toList();
    }

}