package com.suncode.pwfl.workflow.process.map.transition.condition;

import com.suncode.pwfl.util.StringUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public final class SimpleCondition
    extends Condition
{
    private String acceptButtonId;

    private String variableId;

    private Operator operator;

    private String value;

    public SimpleCondition( String acceptButtonId )
    {
        this.acceptButtonId = acceptButtonId;
    }

    public SimpleCondition( String variableId, Operator operator, String value )
    {
        this.variableId = variableId;
        this.operator = operator;
        this.value = value;
    }

    @Override
    public String toConditionText()
    {
        String acceptButtonCondition = getAcceptButtonCondition();
        String variableCondition = getVariableCondition();

        if ( acceptButtonCondition != null && variableCondition != null )
        {
            return String.format( "( %s && %s )", acceptButtonCondition, variableCondition );
        }

        if ( acceptButtonCondition != null )
        {
            return acceptButtonCondition;
        }

        return variableCondition != null ? variableCondition : "";
    }

    private String getAcceptButtonCondition()
    {
        if ( StringUtils.isBlank( acceptButtonId ) )
        {
            return null;
        }

        return String.format( "( Action == '%s' )", acceptButtonId );
    }

    private String getVariableCondition()
    {
        if ( StringUtils.isBlank( variableId ) || StringUtils.isBlank( value ) )
        {
            return null;
        }

        return String.format( "( %s %s %s )", variableId, operator.getOperation(), value );
    }
}
