package com.suncode.pwfl.workflow.process.map.transition.condition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;

import java.util.Arrays;

@Getter
public enum Operator
{
    EQUAL( "==" ),
    NOT_EQUAL( "!==" ),
    LESS_THAN_OR_EQUAL( "<=" ),
    GREATER_THAN_OR_EQUAL( ">=" ),
    LESS_THAN( "<" ),
    GREATER_THAN( ">" );

    @Getter( onMethod_ = { @JsonValue } )
    private final String operation;

    Operator( String operation )
    {
        this.operation = operation;
    }

    @JsonCreator
    public static Operator fromString( String operator )
    {
        return Arrays.stream( Operator.values() )
            .filter( operatorEnum -> operatorEnum.operation.equals( operator ) )
            .findFirst()
            .orElseThrow();
    }

}
