package com.suncode.pwfl.workflow.process.map.transition.condition;

import com.suncode.pwfl.util.StringUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public final class GroupCondition
    extends Condition
{
    private ConditionJoinType operator;

    private List<Condition> conditions;

    @Override
    public String toConditionText()
    {
        if ( conditions == null || conditions.isEmpty() )
        {
            return "";
        }

        List<String> conditionTexts = conditions.stream()
            .map( Condition::toConditionText )
            .filter( StringUtils::isNotBlank )
            .toList();

        if ( conditionTexts.isEmpty() )
        {
            return "";
        }

        if ( conditionTexts.size() == 1 )
        {
            return conditionTexts.get( 0 );
        }

        String delimiter = operator == ConditionJoinType.AND ? " && " : " || ";
        String mergedConditionText = String.join( delimiter, conditionTexts );

        return String.format( "( %s )", mergedConditionText );
    }
}
