package com.suncode.pwfl.workflow.process.map.transition.condition;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "type"
)
@JsonSubTypes( {
    @JsonSubTypes.Type( value = SimpleCondition.class, name = "simple" ),
    @JsonSubTypes.Type( value = GroupCondition.class, name = "group" )
} )
public abstract sealed class Condition
    permits SimpleCondition, GroupCondition
{
    public abstract String toConditionText();
}
