package com.suncode.pwfl.workflow.process.map.transition;

import com.suncode.pwfl.workflow.process.map.transition.condition.Condition;
import lombok.Getter;
import lombok.NonNull;

@Getter
public class Transition
{

    private String id;

    private String sourceId;

    private String targetId;

    private Condition condition;

    public Transition( String id, String sourceId, String targetId )
    {
        this( id, sourceId, targetId, null );
    }

    public Transition( String id, String sourceId, String targetId, Condition condition )
    {
        setId( id );
        setSourceId( sourceId );
        setTargetId( targetId );
        setCondition( condition );
    }

    public void setId( @NonNull String id )
    {
        this.id = id.intern();
    }

    public void setSourceId( @NonNull String sourceId )
    {
        this.sourceId = sourceId.intern();
    }

    public void setTargetId( @NonNull String targetId )
    {
        this.targetId = targetId.intern();
    }

    public void setCondition( Condition condition )
    {
        this.condition = condition;
    }

}