package com.suncode.pwfl.workflow.process.map.query;

import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.process.map.transition.Gateway;
import com.suncode.pwfl.workflow.process.map.transition.Transition;
import lombok.Value;

import java.util.List;
import java.util.Optional;

@Value
public class ProcessMapDataQuery
{
    Process process;

    public Optional<Activity> getActivity( String activityId )
    {
        return process.getActivities().stream()
            .filter( act -> act.getId().equals( activityId ) )
            .findFirst();
    }

    public Optional<Transition> getOutgoingTransitionFromActivity( String activityId )
    {
        return process.getTransitions().stream()
            .filter( transition -> transition.getSourceId().equals( activityId ) )
            .findFirst();
    }

    public Optional<Gateway> getGatewayTransitionFromActivity( String activityId )
    {
        Optional<Transition> transition = getOutgoingTransitionFromActivity( activityId );

        if ( transition.isEmpty() )
        {
            return Optional.empty();
        }
        Transition outgoingTransition = transition.get();
        return process
            .getGateways()
            .stream()
            .filter( gateway -> gateway.getId().equals( outgoingTransition.getTargetId() ) )
            .findFirst();
    }

    public List<Transition> getOutgoingTransitionsFromGateway( String gatewayId )
    {
        return process.getTransitions().stream().filter( transition -> transition.getSourceId().equals( gatewayId ) ).toList();
    }
}
