package com.suncode.pwfl.workflow.process.map.builder;

import com.suncode.pwfl.assistant.AgentContext;
import com.suncode.pwfl.assistant.AgentExecutor;
import com.suncode.pwfl.assistant.model.AgentConfig;
import com.suncode.pwfl.assistant.agent.main.MainAgent;
import com.suncode.pwfl.prompting.LlmService;
import com.suncode.pwfl.workflow.process.map.Process;
import lombok.extern.slf4j.Slf4j;

@SuppressWarnings( "unused" )
@Slf4j
public class LlmProcessMapBuilderImpl
    implements LlmProcessMapBuilder
{
    private final LlmService llmService;

    public LlmProcessMapBuilderImpl( LlmService llmService )
    {
        this.llmService = llmService;
    }

    @Override
    public Process buildProcessMapFromPrompt( String prompt )
    {
        AgentConfig config = new AgentConfig( 7, "Workflołek", "admin" );
        AgentContext context = new AgentContext( llmService, config );

        AgentExecutor agentExecutor = new AgentExecutor( context );
        MainAgent mainAgent = new MainAgent( context );

        agentExecutor.execute( mainAgent, prompt );

        // TODO obsłużyć generowanie id i name procesu przez agentów
        Process processMap = mainAgent.getState().getProcessMap();
        if ( processMap.getId() == null )
        {
            processMap.setId( "proces" );
        }

        if ( processMap.getName() == null )
        {
            processMap.setName( "Proces" );
        }

        return processMap;
    }

}
