package com.suncode.pwfl.workflow.process.map;

import lombok.Getter;
import lombok.NonNull;
import lombok.Setter;

@Getter
public class VariableRef
{

    private String id;

    @Setter
    @NonNull
    private VariableRefType type;

    @Setter
    private int position;

    public VariableRef( String id, int position )
    {
        this( id, VariableRefType.UPDATE, position );
    }

    public VariableRef( String id, VariableRefType type, int position )
    {
        setId( id );
        setType( type );
        setPosition( position );
    }

    public void setId( @NonNull String id )
    {
        this.id = id.intern();
    }

}
