package com.suncode.pwfl.assistant.tools;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.config.AIAssistantObjectMapper;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.agent.transition.tools.AnswerToAgentTool;
import com.suncode.pwfl.assistant.agent.main.tools.ActivitiesVariablesAgentTool;
import com.suncode.pwfl.assistant.agent.main.tools.FinalAnswerTool;
import com.suncode.pwfl.assistant.agent.main.tools.TransitionsAgentTool;
import com.suncode.pwfl.assistant.agent.transition.tools.AppendOutgoingTransitionToActivityTool;
import com.suncode.pwfl.assistant.agent.transition.tools.CreateAcceptButtonsOnActivityTool;
import com.suncode.pwfl.assistant.agent.transition.tools.DeleteAcceptButtonsOnActivityTool;
import com.suncode.pwfl.assistant.agent.transition.tools.DeleteOutgoingTransitionFromActivityTool;
import com.suncode.pwfl.assistant.agent.transition.tools.DeleteTransitionPathsFromGatewayTool;
import com.suncode.pwfl.assistant.agent.transition.tools.GetAcceptButtonsOfActivitiesTool;
import com.suncode.pwfl.assistant.agent.transition.tools.GetOutgoingTransitionOfActivitiesTool;
import com.suncode.pwfl.assistant.agent.transition.tools.SetActivityAsOutgoingTransitionFromSourceActivityIdTool;
import com.suncode.pwfl.assistant.agent.transition.tools.SetGatewayAsOutgoingTransitionFromSourceActivityIdTool;
import com.suncode.pwfl.assistant.agent.transition.tools.UpdateAcceptButtonsOnActivityTool;
import com.suncode.pwfl.assistant.agent.variable.tools.AssignVariableToActivityTool;
import com.suncode.pwfl.assistant.agent.variable.tools.CheckActivitiesExistByActivityNameTool;
import com.suncode.pwfl.assistant.agent.variable.tools.CheckVariablesExistByVariableNameTool;
import com.suncode.pwfl.assistant.agent.variable.tools.CreateActivitiesTool;
import com.suncode.pwfl.assistant.agent.variable.tools.CreateVariablesTool;
import com.suncode.pwfl.assistant.agent.variable.tools.DeleteActivityTool;
import com.suncode.pwfl.assistant.agent.variable.tools.DeleteVariableAssignmentToActivityTool;
import com.suncode.pwfl.assistant.agent.variable.tools.DeleteVariableTool;
import com.suncode.pwfl.assistant.agent.variable.tools.GetAllActivitiesTool;
import com.suncode.pwfl.assistant.agent.variable.tools.GetAllVariablesTool;
import com.suncode.pwfl.assistant.agent.variable.tools.GetProcessNameTool;
import com.suncode.pwfl.assistant.agent.variable.tools.GetVariablesAssignedToActivitiesTool;
import com.suncode.pwfl.assistant.agent.variable.tools.SetProcessNameTool;
import com.suncode.pwfl.assistant.agent.variable.tools.UpdateActivityTool;
import com.suncode.pwfl.assistant.agent.variable.tools.UpdateVariableAssignmentToActivityTool;
import com.suncode.pwfl.assistant.agent.variable.tools.UpdateVariableTool;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
public class ToolRegistry
{
    private final ObjectMapper objectMapper = new AIAssistantObjectMapper();

    private final Map<ToolKey, ToolDefinition> registry = new HashMap<>();

    public ToolRegistry()
    {
        // Main agent
        registerTool( FinalAnswerTool.DEFINITION );
        registerTool( ActivitiesVariablesAgentTool.DEFINITION );
        registerTool( TransitionsAgentTool.DEFINITION );

        // Variable agent
        registerTool( CreateActivitiesTool.DEFINITION );
        registerTool( DeleteActivityTool.DEFINITION );
        registerTool( UpdateActivityTool.DEFINITION );
        registerTool( GetAllActivitiesTool.DEFINITION );
        registerTool( CheckActivitiesExistByActivityNameTool.DEFINITION );
        registerTool( CreateVariablesTool.DEFINITION );
        registerTool( DeleteVariableTool.DEFINITION );
        registerTool( UpdateVariableTool.DEFINITION );
        registerTool( GetAllVariablesTool.DEFINITION );
        registerTool( CheckVariablesExistByVariableNameTool.DEFINITION );
        registerTool( AssignVariableToActivityTool.DEFINITION );
        registerTool( DeleteVariableAssignmentToActivityTool.DEFINITION );
        registerTool( GetVariablesAssignedToActivitiesTool.DEFINITION );
        registerTool( UpdateVariableAssignmentToActivityTool.DEFINITION );
        registerTool( SetProcessNameTool.DEFINITION );
        registerTool( GetProcessNameTool.DEFINITION );
        registerTool( com.suncode.pwfl.assistant.agent.variable.tools.AnswerToAgentTool.DEFINITION );

        // Transition agent
        registerTool( GetOutgoingTransitionOfActivitiesTool.DEFINITION );
        registerTool( SetActivityAsOutgoingTransitionFromSourceActivityIdTool.DEFINITION );
        registerTool( DeleteOutgoingTransitionFromActivityTool.DEFINITION );
        registerTool( AppendOutgoingTransitionToActivityTool.DEFINITION );
        registerTool( SetGatewayAsOutgoingTransitionFromSourceActivityIdTool.DEFINITION );
        registerTool( DeleteTransitionPathsFromGatewayTool.DEFINITION );
        registerTool( CreateAcceptButtonsOnActivityTool.DEFINITION );
        registerTool( DeleteAcceptButtonsOnActivityTool.DEFINITION );
        registerTool( GetAcceptButtonsOfActivitiesTool.DEFINITION );
        registerTool( UpdateAcceptButtonsOnActivityTool.DEFINITION );
        registerTool( AnswerToAgentTool.DEFINITION );
    }

    private void registerTool( ToolDefinition definition )
    {
        registry.put(
            new ToolKey( definition.agentType(), definition.name() ),
            definition
        );
    }

    public List<ToolDefinition> getToolDefinitionsForAgentType( AgentType agentType )
    {
        return registry.entrySet().stream()
            .filter( entry -> entry.getKey().agentType().equals( agentType ) )
            .map( Map.Entry::getValue )
            .toList();
    }

    public Tool createTool( AgentType agentType, String toolName, Map<String, Object> parameters )
        throws ToolCreationException
    {
        ToolKey key = new ToolKey( agentType, toolName );
        ToolDefinition toolData = registry.get( key );

        if ( toolData == null )
        {
            throw new ToolCreationException( "Unknown tool: " + toolName + " for agent type: " + agentType );
        }

        Class<? extends Tool> toolClass = toolData.toolClass();

        try
        {
            return objectMapper.convertValue( parameters, toolClass );
        }
        catch ( Exception e )
        {
            log.error( "Failed to create tool: " + toolName + " for agent type: " + agentType, e );
            throw new ToolCreationException( "Failed to create tool: " + toolName, e );
        }
    }

    public static class ToolCreationException
        extends Exception
    {
        public ToolCreationException( String message )
        {
            super( message );
        }

        public ToolCreationException( String message, Throwable cause )
        {
            super( message, cause );
        }
    }

    private record ToolKey(
        AgentType agentType,
        String toolName
    )
    {

    }

}
