package com.suncode.pwfl.assistant.prompting;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.pwfl.assistant.model.AgentState;

import java.util.List;

public interface PromptProvider
{
    String provide( AgentState state );

    default String formatComponent( ObjectMapper objectMapper, List<Object> components )
        throws JsonProcessingException
    {
        if(components.isEmpty())
        {
            return "No components for now";
        }
        return objectMapper.writeValueAsString( components );
    }
}
