package com.suncode.pwfl.assistant.model;

import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;
import java.util.List;

@Getter
@Builder
public class Task
{
    private String uuid;
    private String conversationUuid;
    @Setter
    private String name;
    private String toolName;

    @Setter
    private AgentTaskState state;

    @Setter
    private List<Action> actions;
    @Setter
    private String description;
    private LocalDateTime created;
    @Setter
    private LocalDateTime updated;
    private Integer failureCount;

    public void incrementFailureCount()
    {
        this.failureCount = this.failureCount != null ? this.failureCount + 1 : 1;
    }
}
