package com.suncode.pwfl.assistant.agent.variable.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;

/**
 * Tool for retrieving all activities from the process map.
 * Warning: This tool can return a lot of data.
 */
public class GetAllActivitiesTool implements Tool
{
    public static final ToolDefinition DEFINITION = new ToolDefinition(
        AgentType.VARIABLE,
        "get_all_activities",
        """
            Returns all activities that are currently added to the process map. Returns the activities in the following format: { "activities": [ { "activityId": "<activityId>", "activityName": "<activityName>" } ] }. Before using this tool, make sure that you really need to use it. This tool can return a lot of data and it can be difficult to read. If user query is not related to all activities, use check_activities_exist_by_activityName tool instead.
            """,
        "To get all activities write {}.",
        GetAllActivitiesTool.class
    );

    @JsonCreator
    public GetAllActivitiesTool()
    {
        // No parameters needed
    }

    @Override
    public ToolResult execute(ToolContext toolContext )
    {
        Process process = toolContext.getProcess();

        if (process.getActivities().isEmpty())
        {
            return new ToolResult(true, "No activities have been added yet on the process map.");
        }

        String formattedData = "";
        int index = 1;
        for (Activity activity : process.getActivities())
        {
            if (!formattedData.isEmpty())
            {
                formattedData += "\n";
            }
            formattedData += index + ". activityId: " + activity.getId() + 
                           ", activityName: " + activity.getName();
            index++;
        }

        return new ToolResult(true, "Successfully retrieved all activities:\n" + formattedData);
    }
}
