package com.suncode.pwfl.assistant.agent.variable;

import com.suncode.pwfl.assistant.AgentContext;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.model.AgentState;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.agent.variable.prompts.VariableActionPromptProvider;
import com.suncode.pwfl.assistant.agent.variable.prompts.VariableActionUsePromptProvider;
import com.suncode.pwfl.assistant.agent.variable.prompts.VariableTaskPromptProvider;
import com.suncode.pwfl.assistant.agent.Agent;
import com.suncode.pwfl.workflow.process.map.Process;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

@Slf4j
public class VariableAgent
    implements Agent
{

    private final AgentState agentState;

    private final VariableActionPromptProvider actionPromptProvider;

    private final VariableActionUsePromptProvider actionUsePromptProvider;

    private final VariableTaskPromptProvider taskPromptProvider;

    public VariableAgent( AgentContext agentContext, Process process )
    {
        this.agentState = new AgentState( process );

        List<ToolDefinition> tools = agentContext
            .getToolRegistry()
            .getToolDefinitionsForAgentType( AgentType.VARIABLE );

        actionPromptProvider = new VariableActionPromptProvider( tools );
        actionUsePromptProvider = new VariableActionUsePromptProvider( tools );
        taskPromptProvider = new VariableTaskPromptProvider( tools );

        log.debug( "Created {}", this );
    }

    @Override
    public AgentType getAgentType()
    {
        return AgentType.VARIABLE;
    }

    @Override
    public AgentState getState()
    {
        return agentState;
    }

    @Override
    public String getActionPrompt()
    {
        return actionPromptProvider.provide( agentState );
    }

    @Override
    public String getActionUsePrompt()
    {
        return actionUsePromptProvider.provide( agentState );
    }

    @Override
    public String getTaskPrompt()
    {
        return taskPromptProvider.provide( agentState );
    }

    @Override
    public String toString()
    {
        return "Variable agent";
    }

}
