package com.suncode.pwfl.assistant.agent.transition.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.agent.transition.prompts.TransitionAgentAnswerPromptProvider;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.util.StringUtils;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

/**
 * Tool for answering the main agent or communicating missing information.
 * Used by transition agent to respond to the main agent.
 */
@Slf4j
@Getter
public class AnswerToAgentTool implements Tool
{
    public static final ToolDefinition DEFINITION = new ToolDefinition(
        AgentType.TRANSITION,
        "answer_to_agent",
        "Use this tool to answer the main agent or communicate to main agent for missing informations.",
        "To answer the user write { \"answer\": \"<answer>\" }",
        AnswerToAgentTool.class
    );

    private final String answer;

    @JsonCreator
    public AnswerToAgentTool(@JsonProperty("answer") String answer)
    {
        this.answer = answer;
    }

    @Override
    public ToolResult execute(ToolContext toolContext )
    {
        if (StringUtils.isBlank(answer))
        {
            return new ToolResult(false, "Error: Invalid payload. Expecting a non-empty \"answer\" string.");
        }

        TransitionAgentAnswerPromptProvider answerPromptProvider = new TransitionAgentAnswerPromptProvider();
        String processMapAnalysisRaw = toolContext.getLlmService().chat(
            answerPromptProvider.provide( toolContext.getState()),
            toolContext.getUserMessage()
        );

        if (StringUtils.isBlank(processMapAnalysisRaw))
        {
            return new ToolResult(false, "Error: Failed to generate response from LLM.");
        }

        return new ToolResult(true, processMapAnalysisRaw);
    }
}
