package com.suncode.pwfl.assistant.agent.transition;

import com.suncode.pwfl.assistant.AgentContext;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.model.AgentState;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.agent.transition.prompts.TransitionActionPromptProvider;
import com.suncode.pwfl.assistant.agent.transition.prompts.TransitionActionUsePromptProvider;
import com.suncode.pwfl.assistant.agent.transition.prompts.TransitionTaskPromptProvider;
import com.suncode.pwfl.assistant.agent.Agent;
import com.suncode.pwfl.workflow.process.map.Process;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

@Slf4j
public class TransitionAgent
    implements Agent
{

    private final AgentState agentState;

    private final TransitionActionPromptProvider actionPromptProvider;

    private final TransitionActionUsePromptProvider actionUsePromptProvider;

    private final TransitionTaskPromptProvider taskPromptProvider;

    public TransitionAgent( AgentContext agentContext, Process process )
    {
        this.agentState = new AgentState( process );

        List<ToolDefinition> tools = agentContext
            .getToolRegistry()
            .getToolDefinitionsForAgentType( AgentType.TRANSITION );

        actionPromptProvider = new TransitionActionPromptProvider( tools );
        actionUsePromptProvider = new TransitionActionUsePromptProvider( tools );
        taskPromptProvider = new TransitionTaskPromptProvider( tools );

        log.debug( "Created {}", this );
    }

    @Override
    public AgentType getAgentType()
    {
        return AgentType.TRANSITION;
    }

    @Override
    public AgentState getState()
    {
        return agentState;
    }

    @Override
    public String getActionPrompt()
    {
        return actionPromptProvider.provide( agentState );
    }

    @Override
    public String getActionUsePrompt()
    {
        return actionUsePromptProvider.provide( agentState );
    }

    @Override
    public String getTaskPrompt()
    {
        return taskPromptProvider.provide( agentState );
    }

    @Override
    public String toString()
    {
        return "Transition agent";
    }

}
