package com.suncode.pwfl.assistant.agent.main.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.agent.main.prompts.MainAgentAnswerPromptProvider;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.util.StringUtils;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

/**
 * Tool for generating final answer to the user.
 * This tool uses LLM to generate a natural language response based on
 * the agent's state and conversation history.
 */
@Slf4j
@Getter
public class FinalAnswerTool
    implements Tool
{
    public static final ToolDefinition DEFINITION = new ToolDefinition(
        AgentType.MAIN,
        "final_answer",
        "Use this tool to answer the user.",
        "To answer the user write { \"answer\": \"<answer>\" }",
        FinalAnswerTool.class
    );

    private final String answer;

    @JsonCreator
    public FinalAnswerTool( @JsonProperty( "answer" ) String answer )
    {
        this.answer = answer;
    }

    @Override
    public ToolResult execute( ToolContext toolContext )
    {
        if ( StringUtils.isBlank( answer ) )
        {
            return new ToolResult( false, "Error: Invalid payload. Expecting a non-empty \"answer\" string." );
        }

        MainAgentAnswerPromptProvider answerPromptProvider = new MainAgentAnswerPromptProvider();
        String processMapAnalysisRaw = toolContext.getLlmService().chat(
            answerPromptProvider.provide( toolContext.getState() ),
            toolContext.getUserMessage()
        );

        if ( StringUtils.isBlank( processMapAnalysisRaw ) )
        {
            return new ToolResult( false, "Error: Failed to generate response from LLM." );
        }

        return new ToolResult( true, processMapAnalysisRaw );
    }
}
