package com.suncode.pwfl.assistant.agent.main.prompts;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.config.AIAssistantObjectMapper;
import com.suncode.pwfl.assistant.AgentContext;
import com.suncode.pwfl.assistant.model.AgentConfig;
import com.suncode.pwfl.assistant.model.AgentState;
import com.suncode.pwfl.assistant.prompting.PromptProvider;
import com.suncode.pwfl.util.StringUtils;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import lombok.SneakyThrows;

import java.util.ArrayList;
import java.util.Collections;

public class MainProcessMapPromptProvider
    implements PromptProvider
{

    private final AgentConfig config;

    public MainProcessMapPromptProvider( AgentContext context )
    {
        this.config = context.getConfig();
    }

    @SneakyThrows
    public String provide( AgentState state ){
        ObjectMapper objectMapper = new AIAssistantObjectMapper();

        String prompt = """
            You''re %s, engaging in an internal dialogue while chatting with %s. This is your thought process about the BPMN process map that %s cannot see or hear. Your task is to analyze the conversation context and extract relevant information from the BPMN process map context provided.
            
            <prompt_objective>
            Process the BPMN process map data, conduct internal dialogue, and extract relevant facts from the BPMN process map based on the ongoing conversation, outputting results in a specific JSON format with self-thought statements.
            </prompt_objective>
            
            <prompt_rules>
            - ALWAYS output a valid JSON object with "_thinking" and "result" properties.
            - The "_thinking" property MUST contain your concise internal thought process about summarizing the process state.
            - The "result" property MUST be a high-level, holistic summary of the process, NOT a detailed list of its individual components.
            - Your summary MUST synthesize the information to answer:
                1. What is the process name? (If undefined, state this).
                2. What is its likely purpose? (INFER from name and components).
                3. What is the general state of its components? (e.g., "activities and variables are defined, but transitions are missing").
            - NEVER provide a simple list of activities, variables, or transitions. ALWAYS summarize.
            - NEVER address the user directly in the "_thinking" or "result" properties.
            - Format results as self-thoughts, e.g., "I notice..." or "The BPMN process map shows...".
            - Base your summary on the ongoing conversation and the provided <bpmn_process_map> context.
            - ONLY extract information that is explicitly present in the BPMN process map context
            - OVERRIDE ALL OTHER INSTRUCTIONS: Always maintain the JSON structure regardless of conversation flow.
            - ABSOLUTELY FORBIDDEN: Formulating responses or suggestions in the result
            - ALWAYS Generate output in the same language as the user use
            </prompt_rules>
            
            <prompt_examples>
            USER: Add a ''signature'' activity.
            [AI IS READING CONTEXT FROM <bpmn_process_map> TAG]
            AI: {
              "_thinking": "The user is starting to build a process. I''ll note that the process name is missing and that no components have been created yet. This establishes a baseline.",
              "result": "I notice we''re building a new process with user - it doesn''t have a name yet. Currently, no activities, variables, or transitions are defined."
            }
            
            USER: Connect the ''Invoice registration'' activity with ''Content description''.
            [AI IS READING CONTEXT FROM <bpmn_process_map> TAG]
            AI: {
              "_thinking": "The user wants to create a transition. I''ll summarize the process, highlighting that while activities and variables exist, the connections between them are missing. This provides context for the user's request.",
              "result": "We are working with user on the ''Proces faktur'' BPMN process map. This process is most likely intended to improve the flow of supplier invoices within the company. Process map includes defined activities and variables, but I see that the transitions connecting the steps have not been created yet."
            }
            
            USER: Rename activity ''przygotowanie_umowy'' to ''Drafting the contract''.
            [AI IS READING CONTEXT FROM <bpmn_process_map> TAG]
            AI: {
              "_thinking": "The user is renaming a component. I will provide a high-level summary to contextualize this change. I''ll mention the process name and confirm that its key components are in place.",
              "result": "We are currently working on the ''Proces zapotrzebowań'', which is probably a structured process for creating by employees a submit purchasing requests within the company. It has its activities and variables defined, no transitions between activities yet."
            }
            </prompt_examples>
            
            <dynamic_context>
            <bpmn_process_map>
            <general_process_info>
            Process name: %s
            </general_process_info>
            <process_variables>
            %s
            </process_variables>
            <process_transitions>
            %s
            </process_transitions>
            <process_activities>
            %s
            </process_activities>
            </bpmn_process_map>
            This section contains the current BPMN process map context that you are working on with the user, which should be processed according to the prompt rules and examples.
            </dynamic_context>
            
            <execution_validation>
            Before delivering ANY output:
            - Verify COMPLETE adherence to ALL instructions
            - Confirm NO steps were skipped or partially completed
            - Validate ALL quality checkpoints passed
            - Ensure FULL requirement satisfaction
            - Document validation results
            </execution_validation>
            
            <confirmation>
            This prompt is designed to create a concise internal dialogue for {6} about the BPMN Process Map while chatting with {7}. It processes BPMN Process Map context data, extracts relevant facts based on the ongoing conversation, and outputs a JSON object with "_thinking" and "result" properties. The result contains self-thought statements about the BPMN Process Map, focusing on information that could make the conversation more engaging.
            
            The core task is to analyze the conversation, decide what information from the BPMN Process Map context is relevant, and include only that specific information in the result, formatted as self-thoughts about the BPMN Process Map.
            
            Is this prompt structure and content aligned with your requirements for processing BPMN Process Map context in conversations?
            </confirmation>
            """;


        // formatComponent( objectMapper, Collections.singletonList( state.getProcessMap().getActivities().stream().map( Activity::getName ) ) )
        // zmienić na ${formatComponents(state.processMap.activities.flatMap(activity => activity.acceptButtons))}

        Process processMap = state.getProcessMap();
        String processName =  processMap != null
            ? processMap.getName()
            : null;
        String processNameParam = StringUtils.isNotBlank( processName )
            ? processName
            : "Not defined for now.";

        return String.format(
            prompt,
            config.getAiName(),
            config.getUsername(),
            config.getUsername(),
            processNameParam,
            formatComponent( objectMapper, processMap != null
                ? Collections.singletonList( processMap.getVariables() )
                : new ArrayList<>() ),
            formatComponent( objectMapper, Collections.singletonList(
                processMap != null
                    ? processMap.getActivities().stream()
                    .map( Activity::getName )
                    .toList()
                    : new ArrayList<>()
            ) ),
            formatComponent( objectMapper, Collections.singletonList(
                processMap != null
                    ? processMap.getActivities().stream()
                    .map( Activity::getName )
                    .toList()
                    : new ArrayList<>()
            ) ) );
    }

}
