package com.suncode.pwfl.assistant.agent.main;

import com.suncode.pwfl.assistant.AgentContext;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.model.AgentState;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.agent.main.prompts.MainActionPromptProvider;
import com.suncode.pwfl.assistant.agent.main.prompts.MainActionUsePromptProvider;
import com.suncode.pwfl.assistant.agent.main.prompts.MainProcessMapPromptProvider;
import com.suncode.pwfl.assistant.agent.main.prompts.MainTaskPromptProvider;
import com.suncode.pwfl.assistant.agent.Agent;
import lombok.extern.slf4j.Slf4j;

import java.util.List;
import java.util.Optional;

@Slf4j
public class MainAgent
    implements Agent
{

    private final AgentState state;

    private final MainProcessMapPromptProvider processMapPromptProvider;

    private final MainActionPromptProvider actionPromptProvider;

    private final MainActionUsePromptProvider actionUsePromptProvider;

    private final MainTaskPromptProvider taskPromptProvider;

    public MainAgent( AgentContext context )
    {
        this.state = new AgentState();

        List<ToolDefinition> tools = context
            .getToolRegistry()
            .getToolDefinitionsForAgentType( AgentType.MAIN );

        processMapPromptProvider = new MainProcessMapPromptProvider( context );
        actionPromptProvider = new MainActionPromptProvider( tools );
        actionUsePromptProvider = new MainActionUsePromptProvider( tools );
        taskPromptProvider = new MainTaskPromptProvider( tools );

        log.debug( "Created {}", this );
    }

    @Override
    public AgentType getAgentType()
    {
        return AgentType.MAIN;
    }

    @Override
    public AgentState getState()
    {
        return state;
    }

    @Override
    public Optional<String> getThinkingPrompt()
    {
        return Optional.of( processMapPromptProvider.provide( state ) );
    }

    @Override
    public String getActionPrompt()
    {
        return actionPromptProvider.provide( state );
    }

    @Override
    public String getActionUsePrompt()
    {
        return actionUsePromptProvider.provide( state );
    }

    @Override
    public String getTaskPrompt()
    {
        return taskPromptProvider.provide( state );
    }

    @Override
    public String toString()
    {
        return "Main agent";
    }

}
