package com.suncode.pwfl.assistant;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.config.AIAssistantObjectMapper;
import com.suncode.pwfl.assistant.model.AgentConfig;
import com.suncode.pwfl.assistant.tools.ToolRegistry;
import com.suncode.pwfl.prompting.LlmService;
import lombok.Getter;

@Getter
public class AgentContext
{

    private final LlmService llmService;

    private final AgentConfig config;

    private final ToolRegistry toolRegistry = new ToolRegistry();

    private final ObjectMapper objectMapper = new AIAssistantObjectMapper();

    public AgentContext( LlmService llmService, AgentConfig config )
    {
        this.llmService = llmService;
        this.config = config;
    }
}
