/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.xpdl.builder;

import com.suncode.pwfl.xpdl.builder.XpdlBaseBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class XpdlTransitionBuilder
extends XpdlBaseBuilder {
    private final String id;
    private final String fromActivityId;
    private final String toActivityId;
    private String conditionText;

    private XpdlTransitionBuilder(String id, String fromActivityId, String toActivityId) {
        this.id = id;
        this.fromActivityId = fromActivityId;
        this.toActivityId = toActivityId;
    }

    public static XpdlTransitionBuilder create(String id, String fromActivityId, String toActivityId) {
        return new XpdlTransitionBuilder(id, fromActivityId, toActivityId);
    }

    public XpdlTransitionBuilder withConditionText(String condition) {
        this.conditionText = condition;
        return this;
    }

    @Override
    public Element buildElement(Document document) {
        Element transition = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Transition");
        transition.setAttribute("Id", this.id);
        transition.setAttribute("From", this.fromActivityId);
        transition.setAttribute("To", this.toActivityId);
        if (this.conditionText != null) {
            Element condition = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Condition");
            condition.setAttribute("Type", "CONDITION");
            condition.setTextContent(this.conditionText);
            transition.appendChild(condition);
        }
        return transition;
    }

    public String getId() {
        return this.id;
    }

    public String getFromActivityId() {
        return this.fromActivityId;
    }

    public String getToActivityId() {
        return this.toActivityId;
    }

    public String getConditionText() {
        return this.conditionText;
    }
}

