/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.xpdl.builder;

import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Package;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.process.map.Variable;
import com.suncode.pwfl.workflow.process.map.VariableRef;
import com.suncode.pwfl.workflow.process.map.VariableType;
import com.suncode.pwfl.workflow.process.map.element.ActivityElement;
import com.suncode.pwfl.workflow.process.map.transition.Gateway;
import com.suncode.pwfl.workflow.process.map.transition.GatewayType;
import com.suncode.pwfl.workflow.process.map.transition.Transition;
import com.suncode.pwfl.workflow.process.map.zipped.ZippedActivity;
import com.suncode.pwfl.workflow.process.map.zipped.ZippedPackage;
import com.suncode.pwfl.workflow.process.map.zipped.ZippedProcess;
import com.suncode.pwfl.xpdl.builder.XpdlAcceptButtonBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlActivityBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlParticipantBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlProcessBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlSplitType;
import com.suncode.pwfl.xpdl.builder.XpdlTransitionBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlTransitionRestrictions;
import com.suncode.pwfl.xpdl.builder.XpdlVariableBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlVariableRefBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlWorkflowPointBuilder;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class XpdlBuilderService {
    private static final int ACTIVITY_BLOCK_WIDTH = 90;
    private static final int ACTIVITY_BLOCK_HEIGHT = 60;
    private static final int ACTIVITY_BLOCK_MARGIN = 50;
    private static final int WORKFLOW_POINT_SIZE = 40;
    private static final int PARTICIPANT_LABEL_OFFSET = 30;
    private static final int MINIMUM_MARGIN_FOR_PROCESS_START = 170;
    private Supplier<String> attachmentDirectoryIdGenerator = () -> UUID.randomUUID().toString();

    public static String buildBy(ZippedPackage pkg) {
        XpdlBuilderService xpdlBuilderService = new XpdlBuilderService();
        return xpdlBuilderService.buildBy(pkg, LocalDateTime.now());
    }

    String buildBy(ZippedPackage zippedPackage, LocalDateTime createdTimestamp) {
        Package pkg = (Package)zippedPackage.getModel();
        XpdlBuilder xpdlBuilder = new XpdlBuilder().withPackageId(pkg.getId()).withPackageName(pkg.getName()).withAuthor("Suncode").withCreated(createdTimestamp);
        for (ZippedProcess zippedProcess : zippedPackage.getZippedProcesses()) {
            this.appendProcess(createdTimestamp, zippedProcess, xpdlBuilder);
        }
        return xpdlBuilder.build();
    }

    private void appendProcess(LocalDateTime createdTimestamp, ZippedProcess zippedProcess, XpdlBuilder xpdlBuilder) {
        this.offsetElementsForProcessStartIfNecessary(zippedProcess);
        Process process = (Process)zippedProcess.getModel();
        XpdlProcessBuilder processBuilder = XpdlProcessBuilder.create(process.getId(), process.getName()).withCreated(createdTimestamp).withAttachmentDirectory(this.attachmentDirectoryIdGenerator.get()).addParticipant(XpdlParticipantBuilder.create("uczestnik_1", "Uczestnik 1"));
        xpdlBuilder.addProcess(processBuilder);
        this.appendVariables(createdTimestamp, zippedProcess, processBuilder);
        this.appendTransitions(zippedProcess, processBuilder);
        this.appendActivities(zippedProcess, processBuilder);
        this.appendProcessEnds(zippedProcess, processBuilder);
    }

    private void offsetElementsForProcessStartIfNecessary(ZippedProcess zippedProcess) {
        ZippedActivity startingZippedActivity = this.getStartingZippedActivity(zippedProcess);
        int startingActivityX = ((ActivityElement)startingZippedActivity.getElement()).getX();
        int estimatedProcessStartPositionX = startingActivityX - 170;
        if (estimatedProcessStartPositionX >= 0) {
            return;
        }
        int offsetX = -estimatedProcessStartPositionX;
        for (ZippedActivity zippedActivity : zippedProcess.getZippedActivities()) {
            ActivityElement activityElement = (ActivityElement)zippedActivity.getElement();
            activityElement.setX(offsetX + activityElement.getX());
        }
    }

    private void appendVariables(LocalDateTime createdTimestamp, ZippedProcess zippedProcess, XpdlProcessBuilder processBuilder) {
        for (Variable variable : ((Process)zippedProcess.getModel()).getVariables()) {
            VariableType type = variable.getType();
            XpdlVariableBuilder variableBuilder = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case VariableType.STRING -> XpdlVariableBuilder.createString(variable.getId(), variable.getName());
                case VariableType.INTEGER -> XpdlVariableBuilder.createInteger(variable.getId(), variable.getName());
                case VariableType.FLOAT -> XpdlVariableBuilder.createFloat(variable.getId(), variable.getName());
                case VariableType.BOOLEAN -> XpdlVariableBuilder.createBoolean(variable.getId(), variable.getName());
                case VariableType.DATE -> XpdlVariableBuilder.createDate(variable.getId(), variable.getName());
                case VariableType.DATE_TIME -> XpdlVariableBuilder.createDateTime(variable.getId(), variable.getName());
            };
            variableBuilder = variableBuilder.withCreationDate(createdTimestamp).withModificationDate(createdTimestamp);
            processBuilder.addVariable(variableBuilder);
        }
    }

    private void appendTransitions(ZippedProcess zippedProcess, XpdlProcessBuilder processBuilder) {
        Set<String> allGatewayIds = this.getAllGatewayIds(zippedProcess);
        int newTransitionId = 1;
        for (Transition transition : ((Process)zippedProcess.getModel()).getTransitions()) {
            String sourceId = transition.getSourceId();
            String targetId = transition.getTargetId();
            if (allGatewayIds.contains(targetId)) {
                List<Transition> gatewayTransitions = ((Process)zippedProcess.getModel()).getTransitions().stream().filter(innerTransition -> innerTransition.getSourceId().equals(targetId)).toList();
                for (Transition gatewayTransition : gatewayTransitions) {
                    String targetActivityId = gatewayTransition.getTargetId();
                    XpdlTransitionBuilder flatTransitionBuilder = XpdlTransitionBuilder.create("transition-" + newTransitionId, sourceId, targetActivityId).withConditionText(gatewayTransition.getConditionText());
                    ++newTransitionId;
                    processBuilder.addTransition(flatTransitionBuilder);
                }
                continue;
            }
            if (allGatewayIds.contains(sourceId)) continue;
            XpdlTransitionBuilder flatTransitionBuilder = XpdlTransitionBuilder.create("transition-" + newTransitionId, sourceId, targetId);
            ++newTransitionId;
            processBuilder.addTransition(flatTransitionBuilder);
        }
    }

    private void appendActivities(ZippedProcess zippedProcess, XpdlProcessBuilder processBuilder) {
        for (ZippedActivity zippedActivity : zippedProcess.getZippedActivities()) {
            Activity activityModel = (Activity)zippedActivity.getModel();
            ActivityElement activityElement = (ActivityElement)zippedActivity.getElement();
            XpdlActivityBuilder activityBuilder = XpdlActivityBuilder.create(activityModel.getId(), activityModel.getName(), "uczestnik_1", activityElement.getX(), activityElement.getY()).withVariables(activityModel.getVariableRefs().stream().sorted(Comparator.comparing(VariableRef::getPosition)).map(variableRef -> XpdlVariableRefBuilder.create(variableRef.getId(), variableRef.getType())).toList());
            this.appendAcceptButtons(processBuilder, zippedActivity, activityBuilder);
            this.appendTransitionRestrictions(zippedProcess, processBuilder, zippedActivity, activityBuilder);
            processBuilder.addActivity(activityBuilder);
        }
    }

    private void appendAcceptButtons(XpdlProcessBuilder processBuilder, ZippedActivity zippedActivity, XpdlActivityBuilder activityBuilder) {
        Activity activityModel = (Activity)zippedActivity.getModel();
        List<XpdlAcceptButtonBuilder> acceptButtonBuilders = activityModel.getAcceptButtons().stream().map(acceptButton -> {
            String targetActivityId = acceptButton.getTargetActivityId();
            String transitionId = processBuilder.getTransitions().stream().filter(xpdlTransitionBuilder -> xpdlTransitionBuilder.getToActivityId().equals(targetActivityId) && xpdlTransitionBuilder.getFromActivityId().equals(activityModel.getId())).map(XpdlTransitionBuilder::getId).findFirst().orElseThrow();
            return XpdlAcceptButtonBuilder.create(acceptButton.getId(), acceptButton.getName(), transitionId);
        }).toList();
        activityBuilder.withAcceptButtons(acceptButtonBuilders);
    }

    private void appendTransitionRestrictions(ZippedProcess zippedProcess, XpdlProcessBuilder processBuilder, ZippedActivity zippedActivity, XpdlActivityBuilder activityBuilder) {
        Activity activityModel = (Activity)zippedActivity.getModel();
        List<XpdlTransitionBuilder> incomingFlatTransitions = processBuilder.getTransitions().stream().filter(transition -> transition.getToActivityId().equals(activityModel.getId())).toList();
        List<XpdlTransitionBuilder> outcomingFlatTransitions = processBuilder.getTransitions().stream().filter(transition -> transition.getFromActivityId().equals(activityModel.getId())).toList();
        if (incomingFlatTransitions.size() < 2 && outcomingFlatTransitions.size() < 2) {
            return;
        }
        XpdlTransitionRestrictions transitionRestrictions = XpdlTransitionRestrictions.create();
        if (incomingFlatTransitions.size() >= 2) {
            transitionRestrictions.withJoinType(activityModel.getJoinType());
        }
        if (outcomingFlatTransitions.size() >= 2) {
            ((Process)zippedProcess.getModel()).getGateways().stream().filter(gateway -> ((Process)zippedProcess.getModel()).getTransitions().stream().anyMatch(transition -> transition.getSourceId().equals(activityModel.getId()) && transition.getTargetId().equals(gateway.getId()))).findFirst().ifPresent(gateway -> transitionRestrictions.withSplitType(switch (gateway.getGatewayType()) {
                default -> throw new IncompatibleClassChangeError();
                case GatewayType.AND -> XpdlSplitType.AND;
                case GatewayType.XOR -> XpdlSplitType.XOR;
            }).withTransitionRefs(outcomingFlatTransitions.stream().map(XpdlTransitionBuilder::getId).toList()));
        }
        activityBuilder.withTransitionRestrictions(transitionRestrictions);
    }

    private void appendProcessEnds(ZippedProcess zippedProcess, XpdlProcessBuilder processBuilder) {
        ZippedActivity zippedStartingActivity = this.getStartingZippedActivity(zippedProcess);
        List<ZippedActivity> endingZippedActivities = this.getEndingZippedActivities(zippedProcess);
        int processStartingPositionX = ((ActivityElement)zippedStartingActivity.getElement()).getX() - 50 - 40;
        int processStartingPositionY = ((ActivityElement)zippedStartingActivity.getElement()).getY() + 10;
        processBuilder.addWorkflowStart(XpdlWorkflowPointBuilder.create("uczestnik_1", ((Activity)zippedStartingActivity.getModel()).getId(), processStartingPositionX, processStartingPositionY));
        for (ZippedActivity endingZippedActivity : endingZippedActivities) {
            int processEndingPositionX = ((ActivityElement)endingZippedActivity.getElement()).getX() + 90 + 50;
            int processEndingPositionY = ((ActivityElement)endingZippedActivity.getElement()).getY() + 10;
            processBuilder.addWorkflowEnd(XpdlWorkflowPointBuilder.create("uczestnik_1", ((Activity)endingZippedActivity.getModel()).getId(), processEndingPositionX, processEndingPositionY));
        }
    }

    private ZippedActivity getStartingZippedActivity(ZippedProcess zippedProcess) {
        Set transitionEndingActivityIds = ((Process)zippedProcess.getModel()).getTransitions().stream().map(Transition::getTargetId).collect(Collectors.toSet());
        return zippedProcess.getZippedActivities().stream().filter(zippedActivity -> !transitionEndingActivityIds.contains(((Activity)zippedActivity.getModel()).getId())).findFirst().orElseThrow();
    }

    private List<ZippedActivity> getEndingZippedActivities(ZippedProcess zippedProcess) {
        Set transitionStartingActivityIds = ((Process)zippedProcess.getModel()).getTransitions().stream().map(Transition::getSourceId).collect(Collectors.toSet());
        return zippedProcess.getZippedActivities().stream().filter(zippedActivity -> !transitionStartingActivityIds.contains(((Activity)zippedActivity.getModel()).getId())).toList();
    }

    private Set<String> getAllGatewayIds(ZippedProcess zippedProcess) {
        return ((Process)zippedProcess.getModel()).getGateways().stream().map(Gateway::getId).collect(Collectors.toSet());
    }

    XpdlBuilderService() {
    }

    void setAttachmentDirectoryIdGenerator(Supplier<String> attachmentDirectoryIdGenerator) {
        this.attachmentDirectoryIdGenerator = attachmentDirectoryIdGenerator;
    }
}

