/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.process.map.builder.tool;

import com.suncode.pwfl.workflow.process.map.VariableType;
import com.suncode.pwfl.workflow.process.map.builder.tool.WorkflowTool;
import com.suncode.pwfl.workflow.process.map.builder.tool.definition.InputSchema;
import com.suncode.pwfl.workflow.process.map.builder.tool.definition.ToolDefinition;
import com.suncode.pwfl.workflow.process.map.builder.tool.definition.TypesFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateVariableTool
extends WorkflowTool {
    private static final Logger log = LoggerFactory.getLogger(CreateVariableTool.class);
    private final TypesFactory typesFactory = new TypesFactory();
    private final ToolDefinition toolDefinition;

    public CreateVariableTool() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", this.typesFactory.produceStringType());
        parameters.put("name", this.typesFactory.produceStringType());
        parameters.put("type", this.typesFactory.produceEnumType(Arrays.stream(VariableType.values()).map(Enum::name).toList()));
        String description = "Creates a variable in the process map with the specified ID, name, and type\n<rules>\n    > The variable name should be supplied by the user, if it is not - you should ask him about it first.\n    > Variable id is created based on a variable name. If the variable name consists of several words, each word should be separated by the character \"_\".\n    > In case a type of variable is not specified, ask the user about it first.\n    > Only types from the following list are allowed: %s.\n</rules>\n";
        this.toolDefinition = ToolDefinition.builder().name("create_variable").description(String.format(description, Arrays.stream(VariableType.values()).map(variableType -> String.format("'%s'", variableType.name())).collect(Collectors.joining(",")))).inputSchema(InputSchema.builder().parameters(parameters).required(List.of("id", "name", "type")).build()).build();
    }

    public TypesFactory getTypesFactory() {
        return this.typesFactory;
    }

    @Override
    public ToolDefinition getToolDefinition() {
        return this.toolDefinition;
    }
}

