/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.process.map.builder;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.pwfl.prompting.LlmService;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.process.map.Variable;
import com.suncode.pwfl.workflow.process.map.VariableRef;
import com.suncode.pwfl.workflow.process.map.VariableRefType;
import com.suncode.pwfl.workflow.process.map.builder.LlmProcessMapBuilder;
import com.suncode.pwfl.workflow.process.map.builder.LlmProcessMapBuilderInstructionProvider;
import com.suncode.pwfl.workflow.process.map.builder.LlmProcessMapBuilderResponse;
import com.suncode.pwfl.workflow.process.map.builder.ProcessMapBuilderImpl;
import com.suncode.pwfl.workflow.process.map.builder.intention.UnknownIntentionException;
import com.suncode.pwfl.workflow.process.map.builder.intention.UserIntention;
import com.suncode.pwfl.workflow.process.map.builder.intention.UserIntentionEvaluation;
import java.util.List;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlmProcessMapBuilderImpl
implements LlmProcessMapBuilder {
    private static final Logger log = LoggerFactory.getLogger(LlmProcessMapBuilderImpl.class);
    private final LlmService llmService;
    private final LlmProcessMapBuilderInstructionProvider instructionProvider = new LlmProcessMapBuilderInstructionProvider();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public LlmProcessMapBuilderImpl(LlmService llmService) {
        this.llmService = llmService;
    }

    @Override
    public Process buildProcessMapFromPrompt(String prompt) {
        UserIntention userIntention = this.resolveUserIntention(prompt);
        if (userIntention == UserIntention.UNKNOWN_ACTION) {
            throw new UnknownIntentionException();
        }
        String finalPrompt = this.getEnhancedPrompt(userIntention, prompt);
        return this.buildProcessMapFromFinalPrompt(finalPrompt);
    }

    private UserIntention resolveUserIntention(String prompt) {
        try {
            String chatResponse = this.llmService.chat(this.instructionProvider.resolveUserIntentionInstruction(), prompt);
            UserIntentionEvaluation userIntentionEvaluation = (UserIntentionEvaluation)this.objectMapper.readValue(chatResponse, UserIntentionEvaluation.class);
            return UserIntention.valueOf(userIntentionEvaluation.action());
        }
        catch (Exception e) {
            log.info("Couldn't resolve user intention from user prompt", (Throwable)e);
            return UserIntention.UNKNOWN_ACTION;
        }
    }

    private String getEnhancedPrompt(UserIntention userIntention, String prompt) {
        if (userIntention == UserIntention.CREATE_PROCESS_WITH_DETAILS) {
            return prompt;
        }
        try {
            return this.llmService.chat(this.instructionProvider.enhanceUserPromptInstruction(), prompt);
        }
        catch (Exception e) {
            log.info("Couldn't enhance user prompt", (Throwable)e);
            return prompt;
        }
    }

    private Process buildProcessMapFromFinalPrompt(String prompt) {
        try {
            String chatResponse = this.llmService.chat(this.instructionProvider.processBuildInstruction(), prompt);
            LlmProcessMapBuilderResponse processMapBuilderResponse = (LlmProcessMapBuilderResponse)this.objectMapper.readValue(chatResponse, LlmProcessMapBuilderResponse.class);
            ProcessMapBuilderImpl processMapBuilder = new ProcessMapBuilderImpl();
            processMapBuilderResponse.functionCalls().stream().forEach(processMapBuilder::apply);
            this.addVariableRefsToActivities(processMapBuilder);
            return processMapBuilder.getProcess();
        }
        catch (Exception e) {
            log.info("Couldn't build process map from user prompt", (Throwable)e);
            return new Process();
        }
    }

    private void addVariableRefsToActivities(ProcessMapBuilderImpl processMapBuilder) {
        List<VariableRef> variableRefs = IntStream.range(0, processMapBuilder.getProcess().getVariables().size()).mapToObj(i -> {
            Variable variable = processMapBuilder.getProcess().getVariables().get(i);
            return new VariableRef(variable.getId(), VariableRefType.UPDATE, i);
        }).toList();
        for (Activity activity : processMapBuilder.getProcess().getActivities()) {
            activity.getVariableRefs().addAll(variableRefs);
        }
    }
}

