package com.suncode.pwfl.xpdl.builder;

import lombok.Getter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import java.util.ArrayList;
import java.util.List;

@Getter
class XpdlTransitionBuilder
    extends XpdlBaseBuilder
{

    private final String id;

    private final String fromActivityId;

    private final String toActivityId;

    private String conditionText;

    private XpdlTransitionBuilder( String id, String fromActivityId, String toActivityId )
    {
        this.id = id;
        this.fromActivityId = fromActivityId;
        this.toActivityId = toActivityId;
    }

    public static XpdlTransitionBuilder create( String id, String fromActivityId, String toActivityId )
    {
        return new XpdlTransitionBuilder( id, fromActivityId, toActivityId );
    }

    public XpdlTransitionBuilder withConditionText( String condition )
    {
        this.conditionText = condition;
        return this;
    }

    @Override
    public Element buildElement( Document document )
    {
        Element transition = document.createElementNS( XPDL_NAMESPACE, ELEMENT_TRANSITION );
        transition.setAttribute( ATTR_ID, id );
        transition.setAttribute( ATTR_FROM, fromActivityId );
        transition.setAttribute( ATTR_TO, toActivityId );

        if ( conditionText != null )
        {
            Element condition = document.createElementNS( XPDL_NAMESPACE, "xpdl:Condition" );
            condition.setAttribute( "Type", "CONDITION" );
            condition.setTextContent( conditionText );

            transition.appendChild( condition );
        }

        return transition;
    }
} 