package com.suncode.pwfl.workflow.process.map.zipped;

import com.google.common.collect.Streams;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.process.map.element.ProcessElement;
import lombok.Getter;

import java.util.List;


@Getter
public class ZippedProcess
    extends Zipped<Process, ProcessElement>
{

    private final List<ZippedActivity> zippedActivities;

    public ZippedProcess( Process model, ProcessElement element )
    {
        super( model, element );

        zippedActivities = Streams.zip(
            model.getActivities().stream(),
            element.getActivities().stream(),
            ZippedActivity::new
        ).toList();
    }

}