package com.suncode.pwfl.workflow.process.map.transition;

import lombok.Getter;
import lombok.NonNull;

@Getter
public class Transition
{

    private String id;

    private String sourceId;

    private String targetId;

    private String conditionText;

    public Transition( String id, String sourceId, String targetId )
    {
        this( id, sourceId, targetId, null );
    }

    public Transition( String id, String sourceId, String targetId, String conditionText )
    {
        setId( id );
        setSourceId( sourceId );
        setTargetId( targetId );
        setConditionText( conditionText );
    }

    public void setId( @NonNull String id )
    {
        this.id = id.intern();
    }

    public void setSourceId( @NonNull String sourceId )
    {
        this.sourceId = sourceId.intern();
    }

    public void setTargetId( @NonNull String targetId )
    {
        this.targetId = targetId.intern();
    }

    public void setConditionText( String conditionText )
    {
        this.conditionText = conditionText != null ? conditionText.intern() : null;
    }

}