package com.suncode.pwfl.workflow.process.map.builder.tool;

import com.suncode.pwfl.workflow.process.map.VariableType;
import com.suncode.pwfl.workflow.process.map.builder.tool.definition.InputSchema;
import com.suncode.pwfl.workflow.process.map.builder.tool.definition.ToolDefinition;
import com.suncode.pwfl.workflow.process.map.builder.tool.definition.TypesFactory;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@Getter
public class CreateVariableTool
    extends WorkflowTool
{
    private final TypesFactory typesFactory = new TypesFactory();

    private final ToolDefinition toolDefinition;

    public CreateVariableTool()
    {
        Map<String, Object> parameters = new HashMap<>();
        parameters.put( "id", typesFactory.produceStringType() );
        parameters.put( "name", typesFactory.produceStringType() );
        parameters.put( "type", typesFactory.produceEnumType( Arrays.stream( VariableType.values() ).map( VariableType::name ).toList() ) );

        String description = """
            Creates a variable in the process map with the specified ID, name, and type
            <rules>
                > The variable name should be supplied by the user, if it is not - you should ask him about it first.
                > Variable id is created based on a variable name. If the variable name consists of several words, each word should be separated by the character "_".
                > In case a type of variable is not specified, ask the user about it first.
                > Only types from the following list are allowed: %s.
            </rules>
            """;

        this.toolDefinition = ToolDefinition.builder()
            .name( "create_variable" )
            .description( String.format( description, Arrays.stream( VariableType.values() )
                .map( variableType -> String.format( "'%s'", variableType.name() ) )
                .collect( Collectors.joining( "," ) ) )
            )
            .inputSchema( InputSchema.builder()
                              .parameters( parameters )
                              .required( List.of( "id", "name", "type" ) )
                              .build() )
            .build();
    }
}
