package com.suncode.pwfl.workflow.process.map.builder.tool;

import com.suncode.pwfl.workflow.process.map.builder.tool.definition.InputSchema;
import com.suncode.pwfl.workflow.process.map.builder.tool.definition.ToolDefinition;
import com.suncode.pwfl.workflow.process.map.builder.tool.definition.TypesFactory;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Getter
public class CreateActivityTool
    extends WorkflowTool
{
    private final TypesFactory typesFactory = new TypesFactory();

    private final ToolDefinition toolDefinition;

    public CreateActivityTool()
    {
        Map<String, Object> parameters = new HashMap<>();
        parameters.put( "id", typesFactory.produceStringType() );
        parameters.put( "name", typesFactory.produceStringType() );

        String description = """
            Creates an activity in the process map with the specified ID and name.
            <rules>
                > The activity name should be supplied by the user, if it is not - you should ask him about it first.
                > Activity id is created based on the task name. If the task name consists of several words, each word should be separated by the character "_" and the whole activity id must be in lower case.
                > Activity id and name must be returned always together!
            </rules>
            """;

        this.toolDefinition = ToolDefinition.builder()
            .name( "create_activity" )
            .description( description )
            .inputSchema( InputSchema.builder()
                              .parameters( parameters )
                              .required( List.of( "id", "name" ) )
                              .build() )
            .build();
    }
}
