package com.suncode.pwfl.workflow.process.map;

import lombok.Getter;
import lombok.NonNull;

import java.util.ArrayList;
import java.util.List;

@Getter
public class Activity
{

    private String id;

    private String name;

    private JoinType joinType;

    private final List<VariableRef> variableRefs = new ArrayList<>();

    private final List<AcceptButton> acceptButtons = new ArrayList<>();

    public Activity( String id, String name )
    {
        this( id, name, JoinType.XOR );
    }

    public Activity( String id, String name, JoinType joinType )
    {
        setId( id );
        setName( name );
        setJoinType( joinType );
    }

    public void setId( @NonNull String id )
    {
        this.id = id.intern();
    }

    public void setName( @NonNull String name )
    {
        this.name = name.intern();
    }

    public void setJoinType( @NonNull JoinType joinType )
    {
        this.joinType = joinType;
    }

}
