package com.suncode.pwfl.workflow.process.map;

import lombok.Getter;
import lombok.NonNull;

@Getter
public class AcceptButton
{

    private String id;

    private String name;

    private String targetActivityId;

    public AcceptButton( String id, String name )
    {
        this( id, name, null);
    }

    public AcceptButton( String id, String name, String targetActivityId )
    {
        setId( id );
        setName( name );
        setTargetActivityId( targetActivityId );
    }

    public void setId( @NonNull String id )
    {
        this.id = id.intern();
    }

    public void setName( @NonNull String name )
    {
        this.name = name.intern();
    }

    public void setTargetActivityId( String targetActivityId )
    {
        this.targetActivityId = targetActivityId != null ? targetActivityId.intern() : null;
    }

}