/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.xpdl.builder;

import com.suncode.pwfl.xpdl.builder.XpdlBaseBuilder;
import java.time.LocalDateTime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class XpdlVariableBuilder
extends XpdlBaseBuilder {
    private final String id;
    private final String name;
    private final VariableType type;
    private StringSubtype subtype = StringSubtype.NONE;
    private String format;
    private String decimalPrecision;
    private String thousandSeparator;
    private LocalDateTime creationDate = LocalDateTime.now();
    private LocalDateTime modificationDate = LocalDateTime.now();

    private XpdlVariableBuilder(String id, String name, VariableType type) {
        this.id = id;
        this.name = name;
        this.type = type;
    }

    private XpdlVariableBuilder withSubtype(StringSubtype subtype) {
        this.subtype = subtype;
        return this;
    }

    private XpdlVariableBuilder withFormat(String format) {
        this.format = format;
        return this;
    }

    private XpdlVariableBuilder withDecimalPrecision(String decimalPrecision) {
        this.decimalPrecision = decimalPrecision;
        return this;
    }

    private XpdlVariableBuilder withThousandSeparator(String thousandSeparator) {
        this.thousandSeparator = thousandSeparator;
        return this;
    }

    public XpdlVariableBuilder withCreationDate(LocalDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public XpdlVariableBuilder withCreationDate(String creationDate) {
        this.creationDate = LocalDateTime.parse(creationDate, DATE_TIME_FORMATTER);
        return this;
    }

    public XpdlVariableBuilder withModificationDate(LocalDateTime modificationDate) {
        this.modificationDate = modificationDate;
        return this;
    }

    public XpdlVariableBuilder withModificationDate(String modificationDate) {
        this.modificationDate = LocalDateTime.parse(modificationDate, DATE_TIME_FORMATTER);
        return this;
    }

    public static XpdlVariableBuilder createInteger(String id, String name) {
        return new XpdlVariableBuilder(id, name, VariableType.INTEGER).withFormat("0,000").withThousandSeparator(" ");
    }

    public static XpdlVariableBuilder createFloat(String id, String name) {
        return new XpdlVariableBuilder(id, name, VariableType.FLOAT).withFormat("0,000.00").withDecimalPrecision("2").withThousandSeparator(" ");
    }

    public static XpdlVariableBuilder createString(String id, String name) {
        return new XpdlVariableBuilder(id, name, VariableType.STRING);
    }

    public static XpdlVariableBuilder createDate(String id, String name) {
        return new XpdlVariableBuilder(id, name, VariableType.STRING).withSubtype(StringSubtype.DATE).withFormat("Y-m-d");
    }

    public static XpdlVariableBuilder createDateTime(String id, String name) {
        return new XpdlVariableBuilder(id, name, VariableType.DATETIME);
    }

    public static XpdlVariableBuilder createBoolean(String id, String name) {
        return new XpdlVariableBuilder(id, name, VariableType.BOOLEAN);
    }

    @Override
    public Element buildElement(Document document) {
        Element dataField = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:DataField");
        dataField.setAttribute("Id", this.id);
        dataField.setAttribute("Name", this.name);
        dataField.setAttribute("IsArray", "FALSE");
        Element dataType = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:DataType");
        Element basicType = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:BasicType");
        basicType.setAttribute("Type", this.type.getType());
        dataType.appendChild(basicType);
        dataField.appendChild(dataType);
        Element extendedAttributes = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:ExtendedAttributes");
        if (this.subtype == StringSubtype.DATE) {
            this.addExtendedAttribute(document, extendedAttributes, "SUBTYPE", this.subtype.getSubtype());
        }
        this.addExtendedAttribute(document, extendedAttributes, "ARRAY", "FALSE");
        if (this.format != null) {
            this.addExtendedAttribute(document, extendedAttributes, "FORMAT", this.format);
        }
        if (this.decimalPrecision != null) {
            this.addExtendedAttribute(document, extendedAttributes, "DECIMAL_PRECISION", this.decimalPrecision);
        }
        if (this.thousandSeparator != null) {
            this.addExtendedAttribute(document, extendedAttributes, "THOUSAND_SEPARATOR", this.thousandSeparator);
        }
        this.addExtendedAttribute(document, extendedAttributes, "CREATION_DATE", this.formatDateTime(this.creationDate));
        this.addExtendedAttribute(document, extendedAttributes, "MODIFICATION_DATE", this.formatDateTime(this.modificationDate));
        dataField.appendChild(extendedAttributes);
        return dataField;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public VariableType getType() {
        return this.type;
    }

    public StringSubtype getSubtype() {
        return this.subtype;
    }

    public String getFormat() {
        return this.format;
    }

    public String getDecimalPrecision() {
        return this.decimalPrecision;
    }

    public String getThousandSeparator() {
        return this.thousandSeparator;
    }

    public LocalDateTime getCreationDate() {
        return this.creationDate;
    }

    public LocalDateTime getModificationDate() {
        return this.modificationDate;
    }

    public static enum StringSubtype {
        NONE(""),
        DATE("DATE");

        private final String subtype;

        private StringSubtype(String subtype) {
            this.subtype = subtype;
        }

        public String getSubtype() {
            return this.subtype;
        }
    }

    public static enum VariableType {
        INTEGER("INTEGER"),
        STRING("STRING"),
        DATETIME("DATETIME"),
        BOOLEAN("BOOLEAN"),
        FLOAT("FLOAT");

        private final String type;

        private VariableType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

