/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.xpdl.builder;

import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Package;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.process.map.Transition;
import com.suncode.pwfl.workflow.process.map.Variable;
import com.suncode.pwfl.workflow.process.map.VariableRef;
import com.suncode.pwfl.workflow.process.map.VariableType;
import com.suncode.pwfl.xpdl.builder.XpdlActivityBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlActivityVariableBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlLinePathBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlParticipantBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlProcessBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlTransitionBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlVariableBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlWorkflowPointBuilder;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;

public class XpdlBuilderService {
    private static final int ACTIVITY_BLOCK_WIDTH = 90;
    private static final int ACTIVITY_BLOCK_HEIGHT = 60;
    private static final int ACTIVITY_BLOCK_MARGIN = 50;
    private static final int WORKFLOW_POINT_SIZE = 40;
    private static final int PARTICIPANT_LABEL_OFFSET = 30;
    private static Supplier<String> attachmentDirectoryIdGenerator = () -> UUID.randomUUID().toString();

    public static String buildBy(Package pkg) {
        return XpdlBuilderService.buildBy(pkg, LocalDateTime.now());
    }

    static String buildBy(Package pkg, LocalDateTime createdTimestamp) {
        XpdlBuilder xpdlBuilder = new XpdlBuilder().withPackageId(pkg.getId()).withPackageName(pkg.getName()).withAuthor("Suncode").withCreated(createdTimestamp);
        for (Process process : pkg.getProcesses()) {
            XpdlBuilderService.appendProcess(createdTimestamp, process, xpdlBuilder);
        }
        return xpdlBuilder.build();
    }

    private static void appendProcess(LocalDateTime createdTimestamp, Process process, XpdlBuilder xpdlBuilder) {
        XpdlProcessBuilder processBuilder = XpdlProcessBuilder.create(process.getId(), process.getName()).withCreated(createdTimestamp).withAttachmentDirectory(attachmentDirectoryIdGenerator.get()).addParticipant(XpdlParticipantBuilder.create("uczestnik_1", "Uczestnik 1"));
        xpdlBuilder.addProcess(processBuilder);
        for (Variable variable : process.getVariables()) {
            VariableType type = variable.getType();
            XpdlVariableBuilder variableBuilder = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case VariableType.STRING -> XpdlVariableBuilder.createString(variable.getId(), variable.getName());
                case VariableType.INTEGER -> XpdlVariableBuilder.createInteger(variable.getId(), variable.getName());
                case VariableType.FLOAT -> XpdlVariableBuilder.createFloat(variable.getId(), variable.getName());
                case VariableType.BOOLEAN -> XpdlVariableBuilder.createBoolean(variable.getId(), variable.getName());
                case VariableType.DATE -> XpdlVariableBuilder.createDate(variable.getId(), variable.getName());
                case VariableType.DATE_TIME -> XpdlVariableBuilder.createDateTime(variable.getId(), variable.getName());
            };
            variableBuilder = variableBuilder.withCreationDate(createdTimestamp).withModificationDate(createdTimestamp);
            processBuilder.addVariable(variableBuilder);
        }
        int processStartX = 80;
        int processStartY = 50;
        int processEndX = processStartX + 40 + 50;
        int processEndY = processStartY;
        for (Activity activity2 : process.getActivities()) {
            List<XpdlActivityVariableBuilder> activityVariables = activity2.getVariableRefs().stream().sorted(Comparator.comparing(VariableRef::getPosition)).map(variableRef -> new XpdlActivityVariableBuilder(variableRef.getId(), variableRef.isEditable())).toList();
            XpdlActivityBuilder activityBuilder = XpdlActivityBuilder.create(activity2.getId(), activity2.getName(), "uczestnik_1", processEndX, processEndY).withVariables(activityVariables);
            processBuilder.addActivity(activityBuilder);
            processEndX += 140;
        }
        for (Transition transition : process.getTransitions()) {
            XpdlActivityBuilder fromActivityBuilder = processBuilder.getActivities().stream().filter(activity -> activity.getId().equals(transition.getFromActivityId())).findFirst().orElseThrow();
            XpdlActivityBuilder toActivityBuilder = processBuilder.getActivities().stream().filter(activity -> activity.getId().equals(transition.getToActivityId())).findFirst().orElseThrow();
            XpdlTransitionBuilder transitionBuilder = XpdlTransitionBuilder.create(transition.getId(), transition.getFromActivityId(), transition.getToActivityId()).addLinePath(XpdlLinePathBuilder.create().moveTo(fromActivityBuilder.getXOffset() + 90, fromActivityBuilder.getYOffset() + 30).lineTo(toActivityBuilder.getXOffset(), toActivityBuilder.getYOffset() + 30).closePath()).addLinePath(XpdlLinePathBuilder.create().rightArrow(toActivityBuilder.getXOffset(), toActivityBuilder.getYOffset() + 30));
            processBuilder.addTransition(transitionBuilder);
        }
        Activity firstActivity = process.getActivities().get(0);
        Activity lastActivity = process.getActivities().get(process.getActivities().size() - 1);
        processBuilder.addWorkflowStart(XpdlWorkflowPointBuilder.create("uczestnik_1", firstActivity.getId(), processStartX, processStartY + 10)).addWorkflowEnd(XpdlWorkflowPointBuilder.create("uczestnik_1", lastActivity.getId(), processEndX, processEndY + 10));
    }

    public static void setAttachmentDirectoryIdGenerator(Supplier<String> attachmentDirectoryIdGenerator) {
        XpdlBuilderService.attachmentDirectoryIdGenerator = attachmentDirectoryIdGenerator;
    }
}

