/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.process.map.builder;

import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Package;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.process.map.Transition;
import com.suncode.pwfl.workflow.process.map.Variable;
import com.suncode.pwfl.workflow.process.map.VariableType;
import com.suncode.pwfl.workflow.process.map.builder.ProcessMapBuilder;
import com.suncode.pwfl.workflow.process.map.builder.function.FunctionCall;
import com.suncode.pwfl.workflow.process.map.builder.function.FunctionCallArgument;
import java.text.Normalizer;
import java.util.Map;

class ProcessMapBuilderImpl
implements ProcessMapBuilder {
    private Process process;
    private static final String REMOVE_ACCENTS_REGEX = "\\p{M}";

    ProcessMapBuilderImpl() {
    }

    @Override
    public void setProcessId(String id) {
        this.getProcess().setId(id);
    }

    @Override
    public void setProcessName(String name) {
        this.getProcess().setName(name);
    }

    @Override
    public void createActivity(String id, String name) {
        this.getProcess().getActivities().add(new Activity(id, name));
    }

    @Override
    public void createTransition(String id, String activityIdFrom, String activityIdTo) {
        this.getProcess().getTransitions().add(new Transition(id, activityIdFrom, activityIdTo));
    }

    @Override
    public void createVariable(String id, String name, VariableType type) {
        this.getProcess().getVariables().add(new Variable(type, id, name));
    }

    @Override
    public Package build() {
        Package pack = new Package();
        pack.getProcesses().clear();
        pack.getProcesses().add(this.getProcess());
        return pack;
    }

    Process getProcess() {
        if (this.process == null) {
            this.process = new Process();
        }
        return this.process;
    }

    void apply(FunctionCall functionCall) {
        Map<String, FunctionCallArgument> arguments = functionCall.arguments();
        switch (functionCall.functionName()) {
            case "set_process_id": {
                this.setProcessId(this.normalizeAndRemoveAccents(arguments.get("id").value()));
                break;
            }
            case "set_process_name": {
                this.setProcessName(this.normalizeAndRemoveAccents(arguments.get("name").value()));
                break;
            }
            case "create_activity": {
                this.createActivity(this.normalizeAndRemoveAccents(arguments.get("id").value()), arguments.get("name").value());
                break;
            }
            case "create_transition": {
                this.createTransition(this.normalizeAndRemoveAccents(arguments.get("id").value()), this.normalizeAndRemoveAccents(arguments.get("activityIdFrom").value()), this.normalizeAndRemoveAccents(arguments.get("activityIdTo").value()));
                break;
            }
            case "create_variable": {
                this.createVariable(this.normalizeAndRemoveAccents(arguments.get("id").value()), arguments.get("name").value(), VariableType.valueOf(arguments.get("type").value()));
            }
        }
    }

    private String normalizeAndRemoveAccents(String input) {
        return this.removeAccents(this.normalize(input));
    }

    private String normalize(String input) {
        return Normalizer.normalize(input, Normalizer.Form.NFKD);
    }

    private String removeAccents(String input) {
        return input.replaceAll(REMOVE_ACCENTS_REGEX, "");
    }
}

