package com.suncode.pwfl.workflow.process.map.builder.tool;

import com.suncode.pwfl.workflow.process.map.builder.tool.definition.InputSchema;
import com.suncode.pwfl.workflow.process.map.builder.tool.definition.ToolDefinition;
import com.suncode.pwfl.workflow.process.map.builder.tool.definition.TypesFactory;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Getter
public class SetProcessNameTool
    extends WorkflowTool
{
    private final TypesFactory typesFactory = new TypesFactory();

    private final ToolDefinition toolDefinition;

    public SetProcessNameTool()
    {
        Map<String, Object> parameters = new HashMap<>();
        parameters.put( "name", typesFactory.produceStringType() );

        String description = """
            Sets the name of the process in the process map builder.
            <rules>
                > Process name should be supplied by the user - in case it is not - ask user for it first.
            </rules>
            """;

        this.toolDefinition = ToolDefinition.builder()
            .name( "set_process_name" )
            .description( description )
            .inputSchema( InputSchema.builder()
                              .parameters( parameters )
                              .required( List.of( "name" ) )
                              .build() )
            .build();
    }


}