package com.suncode.pwfl.workflow.process.map.builder.tool;

import com.suncode.pwfl.workflow.process.map.builder.tool.definition.InputSchema;
import com.suncode.pwfl.workflow.process.map.builder.tool.definition.ToolDefinition;
import com.suncode.pwfl.workflow.process.map.builder.tool.definition.TypesFactory;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Getter
public class SetProcessIdTool
    extends WorkflowTool
{
    private final TypesFactory typesFactory = new TypesFactory();

    private final ToolDefinition toolDefinition;

    public SetProcessIdTool()
    {
        Map<String, Object> parameters = new HashMap<>();
        parameters.put( "id", typesFactory.produceStringType() );

        String description = """
            Sets the ID of the process in the process map builder.
            <rules>
                > Process id is created based on the process name.
                >If the Process name consists of several words, each word should be separated by the character "_" and the whole process id must be in lower case.
            </rules>
            """;

        this.toolDefinition = ToolDefinition.builder()
            .name( "set_process_id" )
            .description( description )
            .inputSchema( InputSchema.builder()
                              .parameters( parameters )
                              .required( List.of( "id" ) )
                              .build() )
            .build();
    }
}
