package com.suncode.pwfl.workflow.process.map.builder.tool;

import com.suncode.pwfl.workflow.process.map.builder.tool.definition.InputSchema;
import com.suncode.pwfl.workflow.process.map.builder.tool.definition.ToolDefinition;
import com.suncode.pwfl.workflow.process.map.builder.tool.definition.TypesFactory;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Getter
public class CreateTransitionTool
    extends WorkflowTool
{
    private final TypesFactory typesFactory = new TypesFactory();

    private final ToolDefinition toolDefinition;

    public CreateTransitionTool()
    {
        Map<String, Object> parameters = new HashMap<>();
        parameters.put( "id", typesFactory.produceStringType() );
        parameters.put( "activityIdFrom", typesFactory.produceStringType() );
        parameters.put( "activityIdTo", typesFactory.produceStringType() );

        String description = """
            Creates a transition between two activities in the process map.
            <rules>
                > The transition id is created based on the first word activity names like in structure: - (first_activity_word)_(second_activity_word).
                > The transition id must be in lower case.
            </rules>
            """;

        this.toolDefinition = ToolDefinition.builder()
            .name( "create_transition" )
            .description( description )
            .inputSchema( InputSchema.builder()
                              .parameters( parameters )
                              .required( List.of( "id", "activityIdFrom", "activityIdTo" ) )
                              .build() )
            .build();
    }
}
